/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import org.web3j.crypto.CipherException;
import org.web3j.crypto.ECKeyPair;
import org.web3j.crypto.Keys;
import org.web3j.crypto.Wallet;
import org.web3j.crypto.WalletFile;
import org.web3j.utils.Numeric;
import org.web3j.utils.Strings;

public class Util {
    public static final String SYMBOL = "itc";

    public static String prependSymbolPrefix(String input) {
        if (!Util.containSymbolPrefix(input)) {
            return SYMBOL + input;
        }
        return input;
    }

    public static String extractAddress(String input) {
        if (input == null) {
            return input;
        }
        return Util.cleanSymbolPrefix(Numeric.cleanHexPrefix((String)input.toLowerCase()));
    }

    public static boolean containSymbolPrefix(String input) {
        return !Strings.isEmpty((String)input) && input.length() > 2 && input.substring(0, 3).equals(SYMBOL);
    }

    public static String cleanSymbolPrefix(String input) {
        if (Util.containSymbolPrefix(input)) {
            return input.substring(3);
        }
        return input;
    }

    public static WalletFile createNewWallet(String password) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException, CipherException {
        ECKeyPair ecKeyPair = Keys.createEcKeyPair();
        WalletFile wallet = Wallet.createStandard((String)password, (ECKeyPair)ecKeyPair);
        return wallet;
    }
}

