/*
 * Decompiled with CFR 0.152.
 */
package iotchain.core.model;

import iotchain.core.crypto.Hash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.web3j.rlp.RlpEncoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class RawTransaction {
    protected BigInteger nonce;
    protected BigInteger gasPrice;
    protected BigInteger gasLimit;
    protected String receivingAddress;
    protected BigInteger value;
    protected String payload;

    public RawTransaction() {
    }

    public RawTransaction(BigInteger nonce, BigInteger gasPrice, BigInteger gasLimit, String receivingAddress, BigInteger value, String payload) {
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.receivingAddress = receivingAddress;
        this.value = value;
        this.payload = payload;
    }

    public BigInteger getNonce() {
        return this.nonce;
    }

    public void setNonce(BigInteger nonce) {
        this.nonce = nonce;
    }

    public BigInteger getGasPrice() {
        return this.gasPrice;
    }

    public void setGasPrice(BigInteger gasPrice) {
        this.gasPrice = gasPrice;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public String getReceivingAddress() {
        return this.receivingAddress;
    }

    public void setReceivingAddress(String receivingAddress) {
        this.receivingAddress = receivingAddress;
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    protected List<RlpType> rlpValuesToSign() {
        ArrayList<RlpType> result = new ArrayList<RlpType>();
        result.add((RlpType)RlpString.create((BigInteger)this.getNonce()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasPrice()));
        result.add((RlpType)RlpString.create((BigInteger)this.getGasLimit()));
        String receivingAddress = this.getReceivingAddress();
        if (receivingAddress != null && receivingAddress.length() > 0) {
            result.add((RlpType)RlpString.create((byte[])Numeric.hexStringToByteArray((String)receivingAddress)));
        } else {
            result.add((RlpType)RlpString.create((String)""));
        }
        result.add((RlpType)RlpString.create((BigInteger)this.getValue()));
        byte[] data = Numeric.hexStringToByteArray((String)this.getPayload());
        result.add((RlpType)RlpString.create((byte[])data));
        return result;
    }

    public byte[] bytesToSign(Long chainId) {
        List<RlpType> result = this.rlpValuesToSign();
        result.add((RlpType)RlpString.create((long)chainId));
        result.add((RlpType)RlpString.create((long)0L));
        result.add((RlpType)RlpString.create((long)0L));
        RlpList rlpList = new RlpList(result);
        byte[] encode = RlpEncoder.encode((RlpType)rlpList);
        return Hash.sha3(encode);
    }
}

