/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.hibernate.type.basic;

import io.hypersistence.utils.hibernate.type.ImmutableType;
import io.hypersistence.utils.hibernate.type.util.Configuration;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.type.spi.TypeBootstrapContext;

public class NullableCharacterType
extends ImmutableType<Character> {
    public static final NullableCharacterType INSTANCE = new NullableCharacterType();

    public NullableCharacterType() {
        super(Character.class);
    }

    public NullableCharacterType(TypeBootstrapContext typeBootstrapContext) {
        super(Character.class, new Configuration(typeBootstrapContext.getConfigurationSettings()));
    }

    public int getSqlType() {
        return 1;
    }

    @Override
    public Character get(ResultSet rs, int position, SharedSessionContractImplementor session, Object owner) throws SQLException {
        String value = rs.getString(position);
        return value != null && value.length() > 0 ? Character.valueOf(value.charAt(0)) : null;
    }

    @Override
    public void set(PreparedStatement st, Character value, int index, SharedSessionContractImplementor session) throws SQLException {
        if (value == null) {
            st.setNull(index, 1);
        } else {
            st.setString(index, String.valueOf(value));
        }
    }

    public Character fromStringValue(CharSequence sequence) throws HibernateException {
        return sequence != null ? Character.valueOf(sequence.charAt(0)) : null;
    }
}

