/*
 * Decompiled with CFR 0.152.
 */
package io.hypersistence.utils.common;

import jakarta.persistence.LockTimeoutException;
import jakarta.persistence.PessimisticLockException;
import java.sql.SQLTimeoutException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.exception.LockAcquisitionException;

public interface ExceptionUtil {
    public static final List<Class<? extends Exception>> LOCK_TIMEOUT_EXCEPTIONS = Arrays.asList(LockAcquisitionException.class, LockTimeoutException.class, org.hibernate.PessimisticLockException.class, PessimisticLockException.class, SQLTimeoutException.class);

    public static <T extends Throwable> T rootCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null && cause != t) {
            return ExceptionUtil.rootCause(cause);
        }
        return (T)t;
    }

    public static boolean isLockTimeout(Throwable e) {
        AtomicReference<Throwable> causeHolder = new AtomicReference<Throwable>(e);
        while (true) {
            Throwable cause = causeHolder.get();
            String failureMessage = cause.getMessage().toLowerCase();
            if (LOCK_TIMEOUT_EXCEPTIONS.stream().anyMatch(c -> c.isInstance(cause)) || failureMessage.contains("timeout") || failureMessage.contains("timed out") || failureMessage.contains("time out") || failureMessage.contains("closed connection") || failureMessage.contains("link failure") || failureMessage.contains("expired or aborted by a conflict")) {
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            causeHolder.set(cause.getCause());
        }
        return false;
    }

    public static boolean isCausedBy(Throwable e, Class<? extends Throwable> exceptionType) {
        AtomicReference<Throwable> causeHolder = new AtomicReference<Throwable>(e);
        while (true) {
            Throwable cause;
            if (exceptionType.isInstance(cause = causeHolder.get())) {
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            causeHolder.set(cause.getCause());
        }
        return false;
    }

    public static boolean isMVCCAnomalyDetection(Throwable e) {
        AtomicReference<Throwable> causeHolder = new AtomicReference<Throwable>(e);
        while (true) {
            Throwable cause = causeHolder.get();
            String lowerCaseMessage = cause.getMessage().toLowerCase();
            if (cause.getMessage().contains("ORA-08177: can't serialize access for this transaction") || lowerCaseMessage.contains("could not serialize access due to concurrent update") || lowerCaseMessage.contains("ould not serialize access due to read/write dependencies among transactions") || lowerCaseMessage.contains("snapshot isolation transaction aborted due to update conflict") || lowerCaseMessage.contains("kconflict") || lowerCaseMessage.contains("unknown transaction, could be recently aborted") || lowerCaseMessage.contains("conflicts with higher priority transaction")) {
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            causeHolder.set(cause.getCause());
        }
        return false;
    }

    public static boolean isConnectionClose(Exception e) {
        Throwable cause = e;
        while (true) {
            if (cause.getMessage().toLowerCase().contains("connection is close") || cause.getMessage().toLowerCase().contains("closed connection") || cause.getMessage().toLowerCase().contains("link failure") || cause.getMessage().toLowerCase().contains("closed")) {
                return true;
            }
            if (cause.getCause() == null || cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

