/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.servicecommon.rest;

import io.helidon.config.Config;
import io.helidon.servicecommon.rest.RestServiceSettings;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.util.Objects;

class RestServiceSettingsImpl
implements RestServiceSettings {
    private final String webContext;
    private final String routing;
    private final CrossOriginConfig crossOriginConfig;

    private RestServiceSettingsImpl(Builder builder) {
        this.webContext = Objects.requireNonNull(builder.webContext, "webContext cannot be null");
        if (this.webContext.isBlank()) {
            throw new IllegalArgumentException("webContext cannot be blank");
        }
        this.routing = builder.routing;
        this.crossOriginConfig = builder.crossOriginConfigBuilder.build();
    }

    @Override
    public String webContext() {
        return this.webContext;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public CrossOriginConfig crossOriginConfig() {
        return this.crossOriginConfig;
    }

    static class Builder
    implements RestServiceSettings.Builder {
        private String webContext;
        private String routing;
        private CrossOriginConfig.Builder crossOriginConfigBuilder = CrossOriginConfig.builder();

        Builder() {
        }

        static Builder create() {
            return new Builder();
        }

        @Override
        public RestServiceSettings.Builder webContext(String webContext) {
            this.webContext = webContext;
            return this;
        }

        @Override
        public RestServiceSettings.Builder routing(String routing) {
            this.routing = routing;
            return this;
        }

        @Override
        public RestServiceSettings.Builder config(Config serviceConfig) {
            serviceConfig.get("web-context").asString().ifPresent(this::webContext);
            serviceConfig.get("routing").asString().ifPresent(this::routing);
            return this;
        }

        @Override
        public RestServiceSettings.Builder crossOriginConfig(CrossOriginConfig.Builder crossOriginConfigBuilder) {
            this.crossOriginConfigBuilder = crossOriginConfigBuilder;
            return this;
        }

        @Override
        public RestServiceSettings.Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            this.crossOriginConfigBuilder = CrossOriginConfig.builder((CrossOriginConfig)crossOriginConfig);
            return this;
        }

        @Override
        public RestServiceSettings build() {
            return new RestServiceSettingsImpl(this);
        }
    }
}

