/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config.spi;

import io.helidon.common.Builder;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigParserException;
import io.helidon.config.spi.ContentImpl;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public interface ConfigParser {
    public static final int PRIORITY = 100;

    public Set<String> supportedMediaTypes();

    @Deprecated
    public ConfigNode.ObjectNode parse(Content var1) throws ConfigParserException;

    default public ConfigNode.ObjectNode parse(Content content, Function<String, Optional<InputStream>> relativeResolver) {
        return this.parse(content);
    }

    default public List<String> supportedSuffixes() {
        return List.of();
    }

    public static interface Content
    extends ConfigContent {
        public Optional<String> mediaType();

        public InputStream data();

        public Charset charset();

        public static Builder builder() {
            return new Builder();
        }

        public static Content create(InputStream data, String mediaType, Object stamp) {
            return ((Builder)Content.builder().data(data).mediaType(mediaType).stamp(stamp)).build();
        }

        public static class Builder
        extends ConfigContent.Builder<Builder>
        implements io.helidon.common.Builder<Builder, Content> {
            private InputStream data;
            private String mediaType;
            private Charset charset = StandardCharsets.UTF_8;

            private Builder() {
            }

            public Builder data(InputStream data) {
                Objects.requireNonNull(data, "Parsable input stream must be provided");
                this.data = data;
                return this;
            }

            public Builder mediaType(String mediaType) {
                Objects.requireNonNull(mediaType, "Media type must be provided, or this method should not be called");
                this.mediaType = mediaType;
                return this;
            }

            public Builder mediaType(Optional<String> mediaType) {
                mediaType.ifPresent(this::mediaType);
                return this;
            }

            public Builder charset(Charset charset) {
                Objects.requireNonNull(charset, "Charset must be provided, or this method should not be called");
                this.charset = charset;
                return this;
            }

            InputStream data() {
                return this.data;
            }

            String mediaType() {
                return this.mediaType;
            }

            Charset charset() {
                return this.charset;
            }

            public Content build() {
                if (null == this.data) {
                    throw new ConfigParserException("Parsable content exists, yet input stream was not configured.");
                }
                return new ContentImpl.ParsableContentImpl(this);
            }
        }
    }
}

