package io.github.wechaty.grpc

import io.github.wechaty.grpc.PuppetGrpc.getServiceDescriptor
import io.github.wechaty.grpc.puppet.Base
import io.github.wechaty.grpc.puppet.Contact
import io.github.wechaty.grpc.puppet.Event
import io.github.wechaty.grpc.puppet.Friendship
import io.github.wechaty.grpc.puppet.Message
import io.github.wechaty.grpc.puppet.Room
import io.github.wechaty.grpc.puppet.RoomInvitation
import io.github.wechaty.grpc.puppet.RoomMember
import io.github.wechaty.grpc.puppet.Tag
import io.grpc.CallOptions
import io.grpc.CallOptions.DEFAULT
import io.grpc.Channel
import io.grpc.Metadata
import io.grpc.ServerServiceDefinition
import io.grpc.ServerServiceDefinition.builder
import io.grpc.Status
import io.grpc.Status.UNIMPLEMENTED
import io.grpc.StatusException
import io.grpc.kotlin.AbstractCoroutineServerImpl
import io.grpc.kotlin.AbstractCoroutineStub
import io.grpc.kotlin.ClientCalls
import io.grpc.kotlin.ClientCalls.serverStreamingRpc
import io.grpc.kotlin.ClientCalls.unaryRpc
import io.grpc.kotlin.ServerCalls
import io.grpc.kotlin.ServerCalls.serverStreamingServerMethodDefinition
import io.grpc.kotlin.ServerCalls.unaryServerMethodDefinition
import io.grpc.kotlin.StubFor
import kotlin.coroutines.CoroutineContext
import kotlin.coroutines.EmptyCoroutineContext
import kotlin.jvm.JvmOverloads
import kotlinx.coroutines.flow.Flow

/**
 * Holder for Kotlin coroutine-based client and server APIs for wechaty.Puppet.
 */
object PuppetGrpcKt {
  /**
   * A stub for issuing RPCs to a(n) wechaty.Puppet service as suspending coroutines.
   */
  @StubFor(PuppetGrpc::class)
  class PuppetCoroutineStub @JvmOverloads constructor(
    channel: Channel,
    callOptions: CallOptions = DEFAULT
  ) : AbstractCoroutineStub<PuppetCoroutineStub>(channel, callOptions) {
    override fun build(channel: Channel, callOptions: CallOptions): PuppetCoroutineStub =
        PuppetCoroutineStub(channel, callOptions)

    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun start(request: Base.StartRequest): Base.StartResponse = unaryRpc(
      channel,
      PuppetGrpc.getStartMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun stop(request: Base.StopRequest): Base.StopResponse = unaryRpc(
      channel,
      PuppetGrpc.getStopMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun logout(request: Base.LogoutRequest): Base.LogoutResponse = unaryRpc(
      channel,
      PuppetGrpc.getLogoutMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun ding(request: Base.DingRequest): Base.DingResponse = unaryRpc(
      channel,
      PuppetGrpc.getDingMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun version(request: Base.VersionRequest): Base.VersionResponse = unaryRpc(
      channel,
      PuppetGrpc.getVersionMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Returns a [Flow] that, when collected, executes this RPC and emits responses from the
     * server as they arrive.  That flow finishes normally if the server closes its response with
     * [`Status.OK`][Status], and fails by throwing a [StatusException] otherwise.  If
     * collecting the flow downstream fails exceptionally (including via cancellation), the RPC
     * is cancelled with that exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return A flow that, when collected, emits the responses from the server.
     */
    fun event(request: Event.EventRequest): Flow<Event.EventResponse> = serverStreamingRpc(
      channel,
      PuppetGrpc.getEventMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactSelfQRCode(request: Contact.ContactSelfQRCodeRequest):
        Contact.ContactSelfQRCodeResponse = unaryRpc(
      channel,
      PuppetGrpc.getContactSelfQRCodeMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactSelfName(request: Contact.ContactSelfNameRequest):
        Contact.ContactSelfNameResponse = unaryRpc(
      channel,
      PuppetGrpc.getContactSelfNameMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactSelfSignature(request: Contact.ContactSelfSignatureRequest):
        Contact.ContactSelfSignatureResponse = unaryRpc(
      channel,
      PuppetGrpc.getContactSelfSignatureMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactPayload(request: Contact.ContactPayloadRequest):
        Contact.ContactPayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getContactPayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactAlias(request: Contact.ContactAliasRequest): Contact.ContactAliasResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getContactAliasMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactAvatar(request: Contact.ContactAvatarRequest): Contact.ContactAvatarResponse
        = unaryRpc(
      channel,
      PuppetGrpc.getContactAvatarMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun contactList(request: Contact.ContactListRequest): Contact.ContactListResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getContactListMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun friendshipPayload(request: Friendship.FriendshipPayloadRequest):
        Friendship.FriendshipPayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getFriendshipPayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun friendshipSearchPhone(request: Friendship.FriendshipSearchPhoneRequest):
        Friendship.FriendshipSearchPhoneResponse = unaryRpc(
      channel,
      PuppetGrpc.getFriendshipSearchPhoneMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun friendshipSearchWeixin(request: Friendship.FriendshipSearchWeixinRequest):
        Friendship.FriendshipSearchWeixinResponse = unaryRpc(
      channel,
      PuppetGrpc.getFriendshipSearchWeixinMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun friendshipAdd(request: Friendship.FriendshipAddRequest):
        Friendship.FriendshipAddResponse = unaryRpc(
      channel,
      PuppetGrpc.getFriendshipAddMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun friendshipAccept(request: Friendship.FriendshipAcceptRequest):
        Friendship.FriendshipAcceptResponse = unaryRpc(
      channel,
      PuppetGrpc.getFriendshipAcceptMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messagePayload(request: Message.MessagePayloadRequest):
        Message.MessagePayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessagePayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageContact(request: Message.MessageContactRequest):
        Message.MessageContactResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageContactMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageFile(request: Message.MessageFileRequest): Message.MessageFileResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getMessageFileMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageImage(request: Message.MessageImageRequest): Message.MessageImageResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getMessageImageMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageMiniProgram(request: Message.MessageMiniProgramRequest):
        Message.MessageMiniProgramResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageMiniProgramMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageUrl(request: Message.MessageUrlRequest): Message.MessageUrlResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getMessageUrlMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageSendContact(request: Message.MessageSendContactRequest):
        Message.MessageSendContactResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageSendContactMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageSendFile(request: Message.MessageSendFileRequest):
        Message.MessageSendFileResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageSendFileMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageSendText(request: Message.MessageSendTextRequest):
        Message.MessageSendTextResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageSendTextMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageSendMiniProgram(request: Message.MessageSendMiniProgramRequest):
        Message.MessageSendMiniProgramResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageSendMiniProgramMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageSendUrl(request: Message.MessageSendUrlRequest):
        Message.MessageSendUrlResponse = unaryRpc(
      channel,
      PuppetGrpc.getMessageSendUrlMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun messageRecall(request: Message.MessageRecallRequest): Message.MessageRecallResponse
        = unaryRpc(
      channel,
      PuppetGrpc.getMessageRecallMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomPayload(request: Room.RoomPayloadRequest): Room.RoomPayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomPayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomList(request: Room.RoomListRequest): Room.RoomListResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomListMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomAdd(request: Room.RoomAddRequest): Room.RoomAddResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomAddMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomAvatar(request: Room.RoomAvatarRequest): Room.RoomAvatarResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomAvatarMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomCreate(request: Room.RoomCreateRequest): Room.RoomCreateResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomCreateMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomDel(request: Room.RoomDelRequest): Room.RoomDelResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomDelMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomQuit(request: Room.RoomQuitRequest): Room.RoomQuitResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomQuitMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomTopic(request: Room.RoomTopicRequest): Room.RoomTopicResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomTopicMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomQRCode(request: Room.RoomQRCodeRequest): Room.RoomQRCodeResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomQRCodeMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomAnnounce(request: Room.RoomAnnounceRequest): Room.RoomAnnounceResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getRoomAnnounceMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomMemberPayload(request: RoomMember.RoomMemberPayloadRequest):
        RoomMember.RoomMemberPayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomMemberPayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomMemberList(request: RoomMember.RoomMemberListRequest):
        RoomMember.RoomMemberListResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomMemberListMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomInvitationPayload(request: RoomInvitation.RoomInvitationPayloadRequest):
        RoomInvitation.RoomInvitationPayloadResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomInvitationPayloadMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun roomInvitationAccept(request: RoomInvitation.RoomInvitationAcceptRequest):
        RoomInvitation.RoomInvitationAcceptResponse = unaryRpc(
      channel,
      PuppetGrpc.getRoomInvitationAcceptMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun tagContactAdd(request: Tag.TagContactAddRequest): Tag.TagContactAddResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getTagContactAddMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun tagContactRemove(request: Tag.TagContactRemoveRequest): Tag.TagContactRemoveResponse
        = unaryRpc(
      channel,
      PuppetGrpc.getTagContactRemoveMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun tagContactDelete(request: Tag.TagContactDeleteRequest): Tag.TagContactDeleteResponse
        = unaryRpc(
      channel,
      PuppetGrpc.getTagContactDeleteMethod(),
      request,
      callOptions,
      Metadata()
    )
    /**
     * Executes this RPC and returns the response message, suspending until the RPC completes
     * with [`Status.OK`][Status].  If the RPC completes with another status, a corresponding
     * [StatusException] is thrown.  If this coroutine is cancelled, the RPC is also cancelled
     * with the corresponding exception as a cause.
     *
     * @param request The request message to send to the server.
     *
     * @return The single response from the server.
     */
    suspend fun tagContactList(request: Tag.TagContactListRequest): Tag.TagContactListResponse =
        unaryRpc(
      channel,
      PuppetGrpc.getTagContactListMethod(),
      request,
      callOptions,
      Metadata()
    )}

  /**
   * Skeletal implementation of the wechaty.Puppet service based on Kotlin coroutines.
   */
  abstract class PuppetCoroutineImplBase(
    coroutineContext: CoroutineContext = EmptyCoroutineContext
  ) : AbstractCoroutineServerImpl(coroutineContext) {
    /**
     * Returns the response to an RPC for wechaty.Puppet.Start.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun start(request: Base.StartRequest): Base.StartResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Start is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.Stop.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun stop(request: Base.StopRequest): Base.StopResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Stop is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.Logout.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun logout(request: Base.LogoutRequest): Base.LogoutResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Logout is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.Ding.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun ding(request: Base.DingRequest): Base.DingResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Ding is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.Version.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun version(request: Base.VersionRequest): Base.VersionResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Version is unimplemented"))

    /**
     * Returns a [Flow] of responses to an RPC for wechaty.Puppet.Event.
     *
     * If creating or collecting the returned flow fails with a [StatusException], the RPC
     * will fail with the corresponding [Status].  If it fails with a
     * [java.util.concurrent.CancellationException], the RPC will fail with status
     * `Status.CANCELLED`.  If creating
     * or collecting the returned flow fails for any other reason, the RPC will fail with
     * `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open fun event(request: Event.EventRequest): Flow<Event.EventResponse> = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.Event is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactSelfQRCode.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactSelfQRCode(request: Contact.ContactSelfQRCodeRequest):
        Contact.ContactSelfQRCodeResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactSelfQRCode is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactSelfName.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactSelfName(request: Contact.ContactSelfNameRequest):
        Contact.ContactSelfNameResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactSelfName is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactSelfSignature.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactSelfSignature(request: Contact.ContactSelfSignatureRequest):
        Contact.ContactSelfSignatureResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactSelfSignature is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactPayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactPayload(request: Contact.ContactPayloadRequest):
        Contact.ContactPayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactPayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactAlias.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactAlias(request: Contact.ContactAliasRequest):
        Contact.ContactAliasResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactAlias is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactAvatar.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactAvatar(request: Contact.ContactAvatarRequest):
        Contact.ContactAvatarResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactAvatar is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.ContactList.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun contactList(request: Contact.ContactListRequest): Contact.ContactListResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.ContactList is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.FriendshipPayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun friendshipPayload(request: Friendship.FriendshipPayloadRequest):
        Friendship.FriendshipPayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.FriendshipPayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.FriendshipSearchPhone.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun friendshipSearchPhone(request: Friendship.FriendshipSearchPhoneRequest):
        Friendship.FriendshipSearchPhoneResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.FriendshipSearchPhone is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.FriendshipSearchWeixin.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun friendshipSearchWeixin(request: Friendship.FriendshipSearchWeixinRequest):
        Friendship.FriendshipSearchWeixinResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.FriendshipSearchWeixin is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.FriendshipAdd.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun friendshipAdd(request: Friendship.FriendshipAddRequest):
        Friendship.FriendshipAddResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.FriendshipAdd is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.FriendshipAccept.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun friendshipAccept(request: Friendship.FriendshipAcceptRequest):
        Friendship.FriendshipAcceptResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.FriendshipAccept is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessagePayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messagePayload(request: Message.MessagePayloadRequest):
        Message.MessagePayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessagePayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageContact.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageContact(request: Message.MessageContactRequest):
        Message.MessageContactResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageContact is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageFile.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageFile(request: Message.MessageFileRequest): Message.MessageFileResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageFile is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageImage.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageImage(request: Message.MessageImageRequest):
        Message.MessageImageResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageImage is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageMiniProgram.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageMiniProgram(request: Message.MessageMiniProgramRequest):
        Message.MessageMiniProgramResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageMiniProgram is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageUrl.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageUrl(request: Message.MessageUrlRequest): Message.MessageUrlResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageUrl is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageSendContact.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageSendContact(request: Message.MessageSendContactRequest):
        Message.MessageSendContactResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageSendContact is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageSendFile.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageSendFile(request: Message.MessageSendFileRequest):
        Message.MessageSendFileResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageSendFile is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageSendText.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageSendText(request: Message.MessageSendTextRequest):
        Message.MessageSendTextResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageSendText is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageSendMiniProgram.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageSendMiniProgram(request: Message.MessageSendMiniProgramRequest):
        Message.MessageSendMiniProgramResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageSendMiniProgram is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageSendUrl.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageSendUrl(request: Message.MessageSendUrlRequest):
        Message.MessageSendUrlResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageSendUrl is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.MessageRecall.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun messageRecall(request: Message.MessageRecallRequest):
        Message.MessageRecallResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.MessageRecall is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomPayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomPayload(request: Room.RoomPayloadRequest): Room.RoomPayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomPayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomList.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomList(request: Room.RoomListRequest): Room.RoomListResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomList is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomAdd.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomAdd(request: Room.RoomAddRequest): Room.RoomAddResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomAdd is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomAvatar.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomAvatar(request: Room.RoomAvatarRequest): Room.RoomAvatarResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomAvatar is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomCreate.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomCreate(request: Room.RoomCreateRequest): Room.RoomCreateResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomCreate is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomDel.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomDel(request: Room.RoomDelRequest): Room.RoomDelResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomDel is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomQuit.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomQuit(request: Room.RoomQuitRequest): Room.RoomQuitResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomQuit is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomTopic.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomTopic(request: Room.RoomTopicRequest): Room.RoomTopicResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomTopic is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomQRCode.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomQRCode(request: Room.RoomQRCodeRequest): Room.RoomQRCodeResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomQRCode is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomAnnounce.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomAnnounce(request: Room.RoomAnnounceRequest): Room.RoomAnnounceResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomAnnounce is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomMemberPayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomMemberPayload(request: RoomMember.RoomMemberPayloadRequest):
        RoomMember.RoomMemberPayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomMemberPayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomMemberList.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomMemberList(request: RoomMember.RoomMemberListRequest):
        RoomMember.RoomMemberListResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomMemberList is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomInvitationPayload.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomInvitationPayload(request: RoomInvitation.RoomInvitationPayloadRequest):
        RoomInvitation.RoomInvitationPayloadResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomInvitationPayload is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.RoomInvitationAccept.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun roomInvitationAccept(request: RoomInvitation.RoomInvitationAcceptRequest):
        RoomInvitation.RoomInvitationAcceptResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.RoomInvitationAccept is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.TagContactAdd.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun tagContactAdd(request: Tag.TagContactAddRequest): Tag.TagContactAddResponse =
        throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.TagContactAdd is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.TagContactRemove.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun tagContactRemove(request: Tag.TagContactRemoveRequest):
        Tag.TagContactRemoveResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.TagContactRemove is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.TagContactDelete.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun tagContactDelete(request: Tag.TagContactDeleteRequest):
        Tag.TagContactDeleteResponse = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.TagContactDelete is unimplemented"))

    /**
     * Returns the response to an RPC for wechaty.Puppet.TagContactList.
     *
     * If this method fails with a [StatusException], the RPC will fail with the corresponding
     * [Status].  If this method fails with a [java.util.concurrent.CancellationException], the RPC
     * will fail
     * with status `Status.CANCELLED`.  If this method fails for any other reason, the RPC will
     * fail with `Status.UNKNOWN` with the exception as a cause.
     *
     * @param request The request from the client.
     */
    open suspend fun tagContactList(request: Tag.TagContactListRequest): Tag.TagContactListResponse
        = throw
        StatusException(UNIMPLEMENTED.withDescription("Method wechaty.Puppet.TagContactList is unimplemented"))

    final override fun bindService(): ServerServiceDefinition = builder(getServiceDescriptor())
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getStartMethod(),
      implementation = ::start
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getStopMethod(),
      implementation = ::stop
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getLogoutMethod(),
      implementation = ::logout
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getDingMethod(),
      implementation = ::ding
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getVersionMethod(),
      implementation = ::version
    ))
      .addMethod(serverStreamingServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getEventMethod(),
      implementation = ::event
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactSelfQRCodeMethod(),
      implementation = ::contactSelfQRCode
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactSelfNameMethod(),
      implementation = ::contactSelfName
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactSelfSignatureMethod(),
      implementation = ::contactSelfSignature
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactPayloadMethod(),
      implementation = ::contactPayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactAliasMethod(),
      implementation = ::contactAlias
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactAvatarMethod(),
      implementation = ::contactAvatar
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getContactListMethod(),
      implementation = ::contactList
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getFriendshipPayloadMethod(),
      implementation = ::friendshipPayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getFriendshipSearchPhoneMethod(),
      implementation = ::friendshipSearchPhone
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getFriendshipSearchWeixinMethod(),
      implementation = ::friendshipSearchWeixin
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getFriendshipAddMethod(),
      implementation = ::friendshipAdd
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getFriendshipAcceptMethod(),
      implementation = ::friendshipAccept
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessagePayloadMethod(),
      implementation = ::messagePayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageContactMethod(),
      implementation = ::messageContact
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageFileMethod(),
      implementation = ::messageFile
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageImageMethod(),
      implementation = ::messageImage
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageMiniProgramMethod(),
      implementation = ::messageMiniProgram
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageUrlMethod(),
      implementation = ::messageUrl
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageSendContactMethod(),
      implementation = ::messageSendContact
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageSendFileMethod(),
      implementation = ::messageSendFile
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageSendTextMethod(),
      implementation = ::messageSendText
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageSendMiniProgramMethod(),
      implementation = ::messageSendMiniProgram
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageSendUrlMethod(),
      implementation = ::messageSendUrl
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getMessageRecallMethod(),
      implementation = ::messageRecall
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomPayloadMethod(),
      implementation = ::roomPayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomListMethod(),
      implementation = ::roomList
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomAddMethod(),
      implementation = ::roomAdd
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomAvatarMethod(),
      implementation = ::roomAvatar
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomCreateMethod(),
      implementation = ::roomCreate
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomDelMethod(),
      implementation = ::roomDel
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomQuitMethod(),
      implementation = ::roomQuit
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomTopicMethod(),
      implementation = ::roomTopic
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomQRCodeMethod(),
      implementation = ::roomQRCode
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomAnnounceMethod(),
      implementation = ::roomAnnounce
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomMemberPayloadMethod(),
      implementation = ::roomMemberPayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomMemberListMethod(),
      implementation = ::roomMemberList
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomInvitationPayloadMethod(),
      implementation = ::roomInvitationPayload
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getRoomInvitationAcceptMethod(),
      implementation = ::roomInvitationAccept
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getTagContactAddMethod(),
      implementation = ::tagContactAdd
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getTagContactRemoveMethod(),
      implementation = ::tagContactRemove
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getTagContactDeleteMethod(),
      implementation = ::tagContactDelete
    ))
      .addMethod(unaryServerMethodDefinition(
      context = this.context,
      descriptor = PuppetGrpc.getTagContactListMethod(),
      implementation = ::tagContactList
    )).build()
  }
}
