/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor.selenium;

import com.t4a.JsonUtils;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.GeminiImageActionProcessor;
import com.t4a.processor.GeminiV2ActionProcessor;
import com.t4a.processor.selenium.SeleniumProcessor;
import com.t4a.transform.GeminiV2PromptTransformer;
import io.github.bonigarcia.wdm.WebDriverManager;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumGeminiProcessor
extends GeminiV2ActionProcessor
implements SeleniumProcessor {
    private static final Logger log = LoggerFactory.getLogger(SeleniumGeminiProcessor.class);
    private WebDriver driver;
    private JsonUtils utils;
    private GeminiV2PromptTransformer transformer;

    public SeleniumGeminiProcessor(WebDriver driver) {
        this.driver = driver;
        this.utils = new JsonUtils();
        this.transformer = new GeminiV2PromptTransformer();
    }

    public SeleniumGeminiProcessor() {
        this.utils = new JsonUtils();
        this.transformer = new GeminiV2PromptTransformer();
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = new ChromeOptions();
        options.addArguments(new String[]{"--headless"});
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--window-size=1920,1080"});
        this.driver = new ChromeDriver(options);
    }

    @Override
    public boolean trueFalseQuery(String question) throws AIProcessingException {
        TakesScreenshot ts = (TakesScreenshot)this.driver;
        byte[] screenshotBytes = (byte[])ts.getScreenshotAs(OutputType.BYTES);
        GeminiImageActionProcessor imageActionProcessor = new GeminiImageActionProcessor();
        return Boolean.valueOf(imageActionProcessor.imageToText(screenshotBytes, question + ", answer in True or False").trim());
    }

    @Override
    public AIProcessor getActionProcessor() {
        return this;
    }

    public SeleniumGeminiProcessor(WebDriver driver, JsonUtils utils, GeminiV2PromptTransformer transformer) {
        this.driver = driver;
        this.utils = utils;
        this.transformer = transformer;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public JsonUtils getUtils() {
        return this.utils;
    }

    public void setUtils(JsonUtils utils) {
        this.utils = utils;
    }

    @Override
    public GeminiV2PromptTransformer getTransformer() {
        return this.transformer;
    }

    public void setTransformer(GeminiV2PromptTransformer transformer) {
        this.transformer = transformer;
    }
}

