/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.processor;

import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.gson.Gson;
import com.t4a.JsonUtils;
import com.t4a.api.AIAction;
import com.t4a.api.AIPlatform;
import com.t4a.api.ActionRisk;
import com.t4a.api.ActionType;
import com.t4a.api.JavaMethodAction;
import com.t4a.api.JavaMethodExecutor;
import com.t4a.api.JavaMethodInvoker;
import com.t4a.detect.ActionCallback;
import com.t4a.detect.ExplainDecision;
import com.t4a.detect.HumanInLoop;
import com.t4a.predict.PredictionLoader;
import com.t4a.processor.AIProcessingException;
import com.t4a.processor.AIProcessor;
import com.t4a.processor.LoggingHumanDecision;
import com.t4a.processor.LogginggExplainDecision;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiV2ActionProcessor
implements AIProcessor {
    private static final Logger log = LoggerFactory.getLogger(GeminiV2ActionProcessor.class);
    private Gson gson;

    public GeminiV2ActionProcessor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public String query(String promptText) throws AIProcessingException {
        GenerateContentResponse response;
        try {
            response = PredictionLoader.getInstance().getChatExplain().sendMessage(promptText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ResponseHandler.getText((GenerateContentResponse)response);
    }

    public GeminiV2ActionProcessor() {
        this.gson = new Gson();
    }

    @Override
    public Object processSingleAction(String promptText, AIAction action, HumanInLoop humanVerification, ExplainDecision explain) throws AIProcessingException {
        return this.processSingleAction(promptText, action, humanVerification, explain, null);
    }

    @Override
    public Object processSingleAction(String promptText, HumanInLoop humanVerification, ExplainDecision explain) throws AIProcessingException {
        return this.processSingleAction(promptText, null, humanVerification, explain);
    }

    public Object processSingleAction(String promptText, AIAction action) throws AIProcessingException {
        return this.processSingleAction(promptText, action, null, null);
    }

    public Object processSingleAction(String promptText, String actionName) throws AIProcessingException {
        AIAction action = PredictionLoader.getInstance().getAiAction(actionName);
        if (action == null) {
            throw new AIProcessingException(" action not found " + actionName);
        }
        return this.processSingleAction(promptText, action, null, null);
    }

    @Override
    public Object processSingleAction(String prompt, AIAction action, HumanInLoop humanVerification, ExplainDecision explain, ActionCallback callback) throws AIProcessingException {
        if (action == null && (action = PredictionLoader.getInstance().getPredictedAction(prompt, AIPlatform.GEMINI)).getActionRisk() == ActionRisk.HIGH) {
            log.warn(" This is a high risk action needs to be explicitly provided by human operator cannot be predicted by AI, {} ", (Object)action.getActionName());
            return "This is a high risk action will not proceed " + action.getActionName();
        }
        if (action.getActionType() == ActionType.JAVAMETHOD) {
            Object result;
            Method method;
            Method[] methods;
            log.debug("found action name {}", (Object)action);
            JavaMethodAction javaMethodAction = (JavaMethodAction)action;
            this.setCallBack(callback, javaMethodAction);
            this.setProcessor(javaMethodAction);
            JsonUtils utils = new JsonUtils();
            Method m = null;
            Class<?> clazz = javaMethodAction.getActionClass();
            for (Method m1 : methods = clazz.getMethods()) {
                if (!m1.getName().equals(action.getActionName())) continue;
                m = m1;
                break;
            }
            if (m == null) {
                throw new AIProcessingException("Method name should matches the actionName  " + action.getActionName() + " class " + action.getClass().getName());
            }
            String jsonStr = utils.convertMethodTOJsonString(m);
            try {
                jsonStr = ResponseHandler.getText((GenerateContentResponse)PredictionLoader.getInstance().getChatExplain().sendMessage(" Here is your prompt {" + prompt + "} - here is the json - " + jsonStr + " - populate the fieldValue and return the json"));
            }
            catch (Exception e) {
                throw new AIProcessingException(" Make sure Gemini properties are set in tools4Ai.properties " + e.getMessage());
            }
            log.info(jsonStr);
            if (!jsonStr.trim().startsWith("{")) {
                jsonStr = utils.extractJson(jsonStr.trim());
            }
            JavaMethodInvoker invoke = new JavaMethodInvoker();
            Object[] obj = invoke.parse(jsonStr);
            List parameterValues = (List)obj[1];
            List parameterTypes = (List)obj[0];
            try {
                method = clazz.getMethod(m.getName(), parameterTypes.toArray(new Class[0]));
            }
            catch (NoSuchMethodException e) {
                throw new AIProcessingException(e);
            }
            try {
                result = this.invokeReflection(method, javaMethodAction, parameterValues);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AIProcessingException(e);
            }
            return result;
        }
        log.debug(action + "");
        JavaMethodExecutor methodExecutor = new JavaMethodExecutor();
        methodExecutor.mapMethod(action);
        log.debug(methodExecutor.getProperties() + "");
        String params = PredictionLoader.getInstance().getActionParams(action, prompt, AIPlatform.GEMINI, methodExecutor.getProperties());
        Object obj = null;
        try {
            if (humanVerification.allow(prompt, action.getActionName(), params).isAIResponseValid()) {
                obj = methodExecutor.action(params, action);
                log.debug(" the action returned " + obj);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AIProcessingException(e);
        }
        return obj;
    }

    @Override
    public Object processSingleAction(String prompt) throws AIProcessingException {
        return this.processSingleAction(prompt, new LoggingHumanDecision(), new LogginggExplainDecision());
    }

    @Override
    public Object processSingleAction(String promptText, ActionCallback callback) throws AIProcessingException {
        return this.processSingleAction(promptText, null, null, null, callback);
    }
}

