/*
 * Decompiled with CFR 0.152.
 */
package com.t4a.api;

import com.google.cloud.vertexai.api.FunctionDeclaration;
import com.google.cloud.vertexai.api.GenerateContentResponse;
import com.google.cloud.vertexai.api.Schema;
import com.google.cloud.vertexai.api.Type;
import com.google.cloud.vertexai.generativeai.ResponseHandler;
import com.google.gson.Gson;
import com.google.protobuf.ListValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.t4a.api.AIActionExecutor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JavaActionExecutor
implements AIActionExecutor {
    private static final Logger log = LoggerFactory.getLogger(JavaActionExecutor.class);

    public Type mapType(Class<?> type) {
        if (type == String.class) {
            return Type.STRING;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Type.INTEGER;
        }
        if (type == Double.TYPE || type == Double.class) {
            return Type.NUMBER;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Type.BOOLEAN;
        }
        if (type.isArray()) {
            return Type.ARRAY;
        }
        if (type == Date.class) {
            return Type.STRING;
        }
        return Type.OBJECT;
    }

    public Type mapTypeForPojo(Class<?> type) {
        if (type == String.class) {
            return Type.STRING;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Type.INTEGER;
        }
        if (type == Double.TYPE || type == Double.class) {
            return Type.NUMBER;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Type.BOOLEAN;
        }
        if (type.isArray()) {
            return Type.ARRAY;
        }
        if (type.equals(Date.class)) {
            return Type.STRING;
        }
        return Type.OBJECT;
    }

    public Type mapType(String type) {
        if (type.equalsIgnoreCase("String")) {
            return Type.STRING;
        }
        if (type.equalsIgnoreCase("int")) {
            return Type.INTEGER;
        }
        if (type.equalsIgnoreCase("integer")) {
            return Type.INTEGER;
        }
        if (type.equalsIgnoreCase("num")) {
            return Type.NUMBER;
        }
        if (type.equalsIgnoreCase("boolean")) {
            return Type.BOOLEAN;
        }
        if (type.equalsIgnoreCase("array")) {
            return Type.ARRAY;
        }
        return Type.OBJECT;
    }

    public Schema mapClassToFun(String className, String funName, String description) throws ClassNotFoundException {
        Field[] fields;
        Schema.Builder schemaBuilder = Schema.newBuilder().setType(Type.OBJECT);
        Class<?> childPojoClass = Class.forName(className);
        for (Field field : fields = childPojoClass.getDeclaredFields()) {
            this.addFieldToSchema(field, schemaBuilder, funName, description);
        }
        return schemaBuilder.build();
    }

    private void addFieldToSchema(Field field, Schema.Builder schemaBuilder, String funName, String description) {
        String fieldName = field.getName();
        Type fieldType = this.mapTypeForPojo(field.getType());
        if (fieldType == Type.OBJECT) {
            this.addObjectField(field, schemaBuilder, funName, description, fieldName);
        } else {
            this.addSimpleField(fieldName, fieldType, schemaBuilder);
        }
    }

    private void addObjectField(Field field, Schema.Builder schemaBuilder, String funName, String description, String fieldName) {
        try {
            Schema nestedSchema = this.mapClassToFun(field.getType().getName(), funName, description);
            schemaBuilder.putProperties(fieldName, nestedSchema).addRequired(fieldName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to map nested class: " + field.getType().getName(), e);
        }
    }

    private void addSimpleField(String fieldName, Type fieldType, Schema.Builder schemaBuilder) {
        Schema propertySchema = Schema.newBuilder().setType(fieldType).setDescription(fieldName).build();
        schemaBuilder.putProperties(fieldName, propertySchema).addRequired(fieldName);
    }

    protected Schema getBuildForJson(Map<String, Object> mapOfMapsForJason) {
        Schema.Builder schemaBuilder = Schema.newBuilder().setType(Type.OBJECT);
        for (Map.Entry<String, Object> entry : mapOfMapsForJason.entrySet()) {
            String property = entry.getKey();
            Object value = entry.getValue();
            Type type = this.mapType(value.getClass());
            Schema.Builder propertySchemaBuilder = Schema.newBuilder().setType(type).setDescription(property);
            if (type == Type.OBJECT) {
                log.debug(property);
                if (value instanceof Map) {
                    Map mapOfMapsForJasonRecursive = (Map)value;
                    propertySchemaBuilder.putProperties(property, this.getBuildForJson(mapOfMapsForJasonRecursive));
                } else if (value instanceof ArrayList) {
                    ArrayList list = (ArrayList)value;
                    for (Object listVal : list) {
                        log.debug(this.getBuildForJson((Map)listVal).toString());
                    }
                }
            }
            Schema propertySchema = propertySchemaBuilder.build();
            schemaBuilder.putProperties(property, propertySchema).addRequired(property);
        }
        return schemaBuilder.build();
    }

    protected Schema getBuild(Map<String, Object> properties) {
        Schema.Builder schemaBuilder = Schema.newBuilder().setType(Type.OBJECT);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String property = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Type) {
                Type type = (Type)entry.getValue();
                Schema propertySchema = Schema.newBuilder().setType(type).setDescription(property).build();
                if (type == Type.OBJECT) {
                    log.debug(property);
                }
                schemaBuilder.putProperties(property, propertySchema).addRequired(property);
                continue;
            }
            try {
                Class valueClass = (Class)value;
                schemaBuilder.putProperties(property, this.mapClassToFun(valueClass.getName(), valueClass.getSimpleName(), " adding sub component"));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return schemaBuilder.build();
    }

    protected Schema getBuild(Type type, String property) {
        return Schema.newBuilder().setType(Type.OBJECT).putProperties(property, Schema.newBuilder().setType(type).setDescription(property).build()).addRequired(property).build();
    }

    protected FunctionDeclaration getBuildFunction(String funName, String discription) {
        return FunctionDeclaration.newBuilder().setName(funName).setDescription(discription).setParameters(this.getBuild(this.getProperties())).build();
    }

    protected FunctionDeclaration getBuildFunction(Map<String, Object> mapOfMapsForJason, String funName, String discription) {
        return FunctionDeclaration.newBuilder().setName(funName).setDescription(discription).setParameters(this.getBuildForJson(mapOfMapsForJason)).build();
    }

    public Map<String, Object> protobufToMap(Map<String, Value> protobufMap) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Map.Entry<String, Value> entry : protobufMap.entrySet()) {
            String key = entry.getKey();
            Value value = entry.getValue();
            Object convertedValue = this.convertValue(value);
            resultMap.put(key, convertedValue);
        }
        return resultMap;
    }

    private Object convertValue(Value value) {
        switch (value.getKindCase()) {
            case NULL_VALUE: {
                return null;
            }
            case NUMBER_VALUE: {
                return value.getNumberValue();
            }
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case STRUCT_VALUE: {
                Struct struct = value.getStructValue();
                HashMap<String, Object> structMap = new HashMap<String, Object>();
                for (Map.Entry entry : struct.getFieldsMap().entrySet()) {
                    structMap.put((String)entry.getKey(), this.convertValue((Value)entry.getValue()));
                }
                return structMap;
            }
            case LIST_VALUE: {
                return value.getListValue().getValuesList().stream().map(this::convertValue).toArray();
            }
            case KIND_NOT_SET: {
                return null;
            }
        }
        return null;
    }

    public Map<String, Object> getPropertyValuesMapMap(GenerateContentResponse response) {
        Map map = ResponseHandler.getContent((GenerateContentResponse)response).getParts(0).getFunctionCall().getArgs().getFieldsMap();
        Map<String, Object> resultMap = this.protobufToMap(map);
        return resultMap;
    }

    public Map<String, Object> getPropertyValuesMap(String responseFromAI) {
        List<String> dataList = Arrays.asList(responseFromAI.split(","));
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String data : dataList) {
            String[] parts = data.split("=");
            if (parts.length == 2) {
                String key = parts[0];
                String value = parts[1];
                map.put(key.trim(), value);
                continue;
            }
            log.warn("Invalid entry: " + data);
        }
        return map;
    }

    public Map<String, Object> getPropertyValuesMap(GenerateContentResponse response) {
        ArrayList<String> propertyNames = new ArrayList<String>(this.getProperties().keySet());
        log.debug(" Trying to parse " + ResponseHandler.getContent((GenerateContentResponse)response));
        HashMap<String, Object> propertyValues = new HashMap<String, Object>();
        for (String propertyName : propertyNames) {
            Value value;
            if (ResponseHandler.getContent((GenerateContentResponse)response).getPartsList().size() <= 0 || (value = (Value)ResponseHandler.getContent((GenerateContentResponse)response).getParts(0).getFunctionCall().getArgs().getFieldsMap().get(propertyName)) == null) continue;
            if (value.hasBoolValue()) {
                propertyValues.put(propertyName, value.getBoolValue());
                continue;
            }
            if (value.hasStringValue()) {
                propertyValues.put(propertyName, value.getStringValue());
                continue;
            }
            if (value.hasListValue()) {
                JavaActionExecutor.extractedList(propertyName, value, propertyValues);
                continue;
            }
            if (!value.hasNumberValue()) continue;
            if (this.getProperties().get(propertyName).equals(Type.INTEGER)) {
                propertyValues.put(propertyName, (int)value.getNumberValue());
                continue;
            }
            propertyValues.put(propertyName, value.getNumberValue());
        }
        return propertyValues;
    }

    private static void extractedList(String propertyName, Value value, Map<String, Object> propertyValues) {
        ListValue lv = value.getListValue();
        List valueFromList = lv.getValuesList();
        if (valueFromList.size() > 0) {
            if (((Value)valueFromList.get(0)).hasStringValue()) {
                JavaActionExecutor.extractedString(propertyName, valueFromList, propertyValues);
            } else if (((Value)valueFromList.get(0)).hasBoolValue()) {
                JavaActionExecutor.extractedBoolean(propertyName, valueFromList, propertyValues);
            } else if (((Value)valueFromList.get(0)).hasListValue()) {
                JavaActionExecutor.extractedList(propertyName, (Value)valueFromList.get(0), propertyValues);
            }
        }
    }

    private static void extractedString(String propertyName, List<Value> valueFromList, Map<String, Object> propertyValues) {
        String[] args = new String[valueFromList.size()];
        int count = 0;
        for (Value v : valueFromList) {
            args[count] = v.getStringValue();
            ++count;
        }
        propertyValues.put(propertyName, args);
    }

    private static void extractedBoolean(String propertyName, List<Value> valueFromList, Map<String, Object> propertyValues) {
        Boolean[] args = new Boolean[valueFromList.size()];
        int count = 0;
        for (Value v : valueFromList) {
            args[count] = v.getBoolValue();
            ++count;
        }
        propertyValues.put(propertyName, args);
    }

    public String getPropertyValuesJsonString(GenerateContentResponse response) {
        String jsonString = this.getGson().toJson(this.getPropertyValuesMap(response));
        return jsonString;
    }

    public String getPropertyValuesJsonString(GenerateContentResponse response, boolean asIs) {
        String jsonString = this.getGson().toJson((Object)ResponseHandler.getContent((GenerateContentResponse)response).getParts(0).getFunctionCall().getArgs().getFieldsMap());
        return jsonString;
    }

    protected abstract Map<String, Object> getProperties();

    protected abstract Gson getGson();
}

