/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.common.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.t4a.predict.PredictionLoader;
import io.github.vishalmysore.a2a.domain.JsonRpcRequest;
import io.github.vishalmysore.a2a.domain.Task;
import io.github.vishalmysore.a2a.domain.TaskCancelParams;
import io.github.vishalmysore.a2a.domain.TaskGetPushNotificationParams;
import io.github.vishalmysore.a2a.domain.TaskQueryParams;
import io.github.vishalmysore.a2a.domain.TaskResubscriptionParams;
import io.github.vishalmysore.a2a.domain.TaskSendParams;
import io.github.vishalmysore.a2a.domain.TaskSendSubscribeParams;
import io.github.vishalmysore.a2a.domain.TaskSetPushNotificationParams;
import io.github.vishalmysore.a2a.server.A2ARPCController;
import io.github.vishalmysore.a2a.server.A2ATaskController;
import io.github.vishalmysore.a2a.server.DyanamicTaskContoller;
import io.github.vishalmysore.mcp.domain.JSONRPCResponse;
import io.github.vishalmysore.mcp.domain.ListPromptsResult;
import io.github.vishalmysore.mcp.domain.ListResourcesRequest;
import io.github.vishalmysore.mcp.domain.ListResourcesResult;
import io.github.vishalmysore.mcp.domain.Resource;
import io.github.vishalmysore.mcp.domain.Tool;
import io.github.vishalmysore.mcp.domain.ToolCallRequest;
import io.github.vishalmysore.mcp.server.MCPToolsController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ResponseStatusException;

public class JsonRpcController
implements A2ARPCController {
    private static final Logger log = Logger.getLogger(JsonRpcController.class.getName());
    private DyanamicTaskContoller dynamicTaskController;
    private MCPToolsController mcpToolsController;

    public JsonRpcController() {
        this.dynamicTaskController = new DyanamicTaskContoller();
        this.mcpToolsController = new MCPToolsController();
        this.mcpToolsController.init();
    }

    public JsonRpcController(ApplicationContext applicationContext) {
        PredictionLoader.getInstance((ApplicationContext)applicationContext);
        this.dynamicTaskController = new DyanamicTaskContoller();
        this.mcpToolsController = new MCPToolsController();
        this.mcpToolsController.init();
    }

    @Override
    public A2ATaskController getTaskController() {
        return this.dynamicTaskController;
    }

    public MCPToolsController getMCPToolsController() {
        return this.mcpToolsController;
    }

    public void setMcpToolsController(MCPToolsController mcpToolsController) {
        this.mcpToolsController = mcpToolsController;
    }

    @Override
    public Object handleRpc(@RequestBody JsonRpcRequest request) {
        String method = request.getMethod();
        Object params = request.getParams();
        log.info(request.toString());
        this.preProcessing(method, params);
        ResponseEntity<Task> result = null;
        switch (method) {
            case "tasks/send": {
                TaskSendParams sendParams = (TaskSendParams)new ObjectMapper().convertValue(params, TaskSendParams.class);
                result = this.getTaskController().sendTask(sendParams, null, false);
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/get": {
                TaskQueryParams queryParams = (TaskQueryParams)new ObjectMapper().convertValue(params, TaskQueryParams.class);
                result = this.getTaskController().getTask(queryParams.getId(), queryParams.getHistoryLength());
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/sendSubscribe": {
                TaskSendSubscribeParams sendSubscribeParams = (TaskSendSubscribeParams)new ObjectMapper().convertValue(params, TaskSendSubscribeParams.class);
                result = this.getTaskController().sendSubscribeTask(sendSubscribeParams);
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/cancel": {
                TaskCancelParams cancelParams = (TaskCancelParams)new ObjectMapper().convertValue(params, TaskCancelParams.class);
                result = this.getTaskController().cancelTask(cancelParams.getId());
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/setPushNotification": {
                TaskSetPushNotificationParams setPushParams = (TaskSetPushNotificationParams)new ObjectMapper().convertValue(params, TaskSetPushNotificationParams.class);
                result = this.getTaskController().setTaskPushNotification(setPushParams);
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/getPushNotification": {
                TaskGetPushNotificationParams getPushParams = (TaskGetPushNotificationParams)new ObjectMapper().convertValue(params, TaskGetPushNotificationParams.class);
                result = this.getTaskController().getTaskPushNotification(getPushParams);
                this.postProcessing(method, result);
                return result;
            }
            case "tasks/resubscribe": {
                TaskResubscriptionParams resubParams = (TaskResubscriptionParams)new ObjectMapper().convertValue(params, TaskResubscriptionParams.class);
                result = this.getTaskController().resubscribeToTask(resubParams);
                this.postProcessing(method, result);
                return result;
            }
            case "initialize": {
                HashMap<String, Object> response = new HashMap<String, Object>();
                HashMap<String, Object> mcpResult = new HashMap<String, Object>();
                HashMap<String, String> serverInfo = new HashMap<String, String>();
                HashMap capabilities = new HashMap();
                HashMap tools = new HashMap();
                serverInfo.put("name", "MCP Server");
                serverInfo.put("version", "1.0.0");
                capabilities.put("tools", tools);
                mcpResult.put("protocolVersion", "2024-11-05");
                mcpResult.put("serverInfo", serverInfo);
                mcpResult.put("capabilities", capabilities);
                response.put("jsonrpc", "2.0");
                response.put("id", request.getId());
                response.put("result", mcpResult);
                this.postProcessing(method, response);
                return response;
            }
            case "notifications/initialized": {
                return ResponseEntity.noContent().build();
            }
            case "tools/list": {
                ResponseEntity<Map<String, List<Tool>>> toolsResponse = this.getMCPToolsController().listTools();
                HashMap<String, Object> response = new HashMap<String, Object>();
                HashMap mcpResult = new HashMap();
                mcpResult.put("tools", ((Map)toolsResponse.getBody()).get("tools"));
                mcpResult.put("_meta", new HashMap());
                response.put("jsonrpc", "2.0");
                response.put("id", request.getId());
                response.put("result", mcpResult);
                this.postProcessing(method, response);
                return response;
            }
            case "tools/call": {
                ToolCallRequest toolRequest = new ToolCallRequest();
                if (request.getParams() instanceof Map) {
                    Map mcpParams = (Map)request.getParams();
                    toolRequest.setName((String)mcpParams.get("name"));
                    toolRequest.setArguments((Map)mcpParams.get("arguments"));
                }
                ResponseEntity<JSONRPCResponse> toolResponse = this.getMCPToolsController().callTool(toolRequest);
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("jsonrpc", "2.0");
                response.put("id", request.getId());
                response.put("result", ((JSONRPCResponse)toolResponse.getBody()).getResult());
                this.postProcessing(method, response);
                return response;
            }
            case "resources/list": {
                ListResourcesRequest listResourcesRequest = (ListResourcesRequest)new ObjectMapper().convertValue((Object)request, ListResourcesRequest.class);
                ListResourcesResult listResourcesResult = new ListResourcesResult();
                listResourcesResult.setResources(new ArrayList<Resource>());
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("jsonrpc", "2.0");
                response.put("id", request.getId());
                response.put("result", listResourcesResult);
                this.getMCPToolsController().addResources(listResourcesResult);
                this.postProcessing(method, response);
                return response;
            }
            case "notifications/cancelled": {
                return ResponseEntity.noContent().build();
            }
            case "prompts/list": {
                ListPromptsResult listPromptsResult = new ListPromptsResult();
                HashMap<String, Object> response = new HashMap<String, Object>();
                response.put("jsonrpc", "2.0");
                response.put("id", request.getId());
                response.put("result", listPromptsResult);
                this.getMCPToolsController().addPrompts(listPromptsResult);
                this.postProcessing(method, response);
                return response;
            }
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Method not found: " + method);
    }
}

