/*
 * Decompiled with CFR 0.152.
 */
package io.github.vishalmysore.a2a.server;

import com.t4a.api.GroupInfo;
import com.t4a.predict.PredictionLoader;
import com.t4a.transform.GeminiV2PromptTransformer;
import com.t4a.transform.PromptTransformer;
import io.github.vishalmysore.a2a.domain.AgentCard;
import io.github.vishalmysore.a2a.domain.Authentication;
import io.github.vishalmysore.a2a.domain.Capabilities;
import io.github.vishalmysore.a2a.domain.Provider;
import io.github.vishalmysore.a2a.domain.Skill;
import io.github.vishalmysore.a2a.server.A2AAgentCardController;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;

public class DynamicAgentCardController
implements A2AAgentCardController {
    private PromptTransformer promptTransformer = new GeminiV2PromptTransformer();

    @Override
    public PromptTransformer getPromptTransformer() {
        return this.promptTransformer;
    }

    @Override
    public ResponseEntity<AgentCard> getAgentCard() {
        AgentCard agentCard = new AgentCard();
        agentCard.setName("TicketQueen : Ticket Booking Agent");
        Map actions = PredictionLoader.getInstance().getPredictions();
        StringBuilder description = new StringBuilder("This agent can help you with: ");
        actions.values().forEach(action -> description.append(action.getActionName()).append(" - ").append(action.getDescription()).append(", "));
        if (description.length() > 2) {
            description.setLength(description.length() - 2);
        }
        agentCard.setDescription(description.toString());
        agentCard.setUrl("http://localhost:8080");
        agentCard.setProvider(new Provider("Ticket Corp", "https://github.com/vishalmysore/choturobo"));
        agentCard.setVersion("1.0.0");
        agentCard.setDocumentationUrl("https://github.com/vishalmysore/Tools4AI");
        agentCard.setCapabilities(new Capabilities(false, false, false));
        agentCard.setAuthentication(new Authentication(new String[]{"Bearer"}));
        agentCard.setDefaultInputModes(new String[]{"text/plain"});
        agentCard.setDefaultOutputModes(new String[]{"application/json"});
        Map groupActions = PredictionLoader.getInstance().getActionGroupList().getGroupActions();
        ArrayList<Skill> skills = new ArrayList<Skill>();
        for (Map.Entry entry : groupActions.entrySet()) {
            String[] stringArray;
            GroupInfo groupInfo = (GroupInfo)entry.getKey();
            String actionTags = (String)entry.getValue();
            Skill skill = new Skill();
            skill.setId(groupInfo.getGroupName().toLowerCase().replace(" ", "-"));
            skill.setName(groupInfo.getGroupName());
            skill.setDescription(groupInfo.getGroupDescription());
            if (actionTags != null) {
                stringArray = actionTags.toLowerCase().split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = groupInfo.getGroupName().toLowerCase();
            }
            String[] tags = stringArray;
            skill.setTags(tags);
            skill.setExamples(new String[]{"Example for " + groupInfo.getGroupName()});
            skill.setInputModes(new String[]{"application/json"});
            skill.setOutputModes(new String[]{"application/json"});
            skills.add(skill);
        }
        agentCard.setSkills(List.of(skills.toArray(new Skill[0])));
        return ResponseEntity.ok((Object)agentCard);
    }
}

