/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import toolgood.words.WordsSearch;
import toolgood.words.WordsSearchResult;

public class PinyinDict {
    private static Map<String, Integer[]> _pyName;
    private static String[] _pyShow;
    private static Integer[] _pyIndex;
    private static Integer[] _pyData;
    private static Integer[] _wordPyIndex;
    private static Integer[] _wordPy;
    private static WordsSearch _search;
    private static final Object lockObj;

    public static String[] getPyShow() throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        return _pyShow;
    }

    public static String[] GetPinyinList(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        PinyinDict.InitPyWords();
        String[] list = new String[text.length()];
        List<WordsSearchResult> pos = _search.FindAll(text);
        Integer pindex = -1;
        for (WordsSearchResult p : pos) {
            if (p.Start <= pindex) continue;
            for (int i = 0; i < p.Keyword.length(); ++i) {
                list[i + p.Start] = _pyShow[_wordPy[i + _wordPyIndex[p.Index]] + tone];
            }
            pindex = p.End;
        }
        for (int i = 0; i < text.length(); ++i) {
            Character c;
            if (list[i] != null || (c = Character.valueOf(text.charAt(i))).charValue() < '\u3400' || c.charValue() > '\u9fd5') continue;
            int index = c.charValue() - 13312;
            int start = _pyIndex[index];
            int end = _pyIndex[index + 1];
            if (end <= start) continue;
            list[i] = _pyShow[_pyData[start] + tone];
        }
        return list;
    }

    public static String GetPinyin(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        String[] list = PinyinDict.GetPinyinList(text, tone);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            if (s != null) {
                sb.append(list[i]);
                continue;
            }
            sb.append(text.charAt(i));
        }
        return sb.toString();
    }

    public static String GetFirstPinyin(String text, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        String[] list = PinyinDict.GetPinyinList(text, tone);
        StringBuilder sb = new StringBuilder(text);
        for (int i = 0; i < list.length; ++i) {
            String c = list[i];
            if (c == null) continue;
            sb.setCharAt(i, c.charAt(0));
        }
        return sb.toString();
    }

    public static List<String> GetAllPinyin(Character c, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        if (c.charValue() >= '\u3400' && c.charValue() <= '\u9fd5') {
            int index = c.charValue() - 13312;
            ArrayList<String> list = new ArrayList<String>();
            int start = _pyIndex[index];
            int end = _pyIndex[index + 1];
            if (end > start) {
                for (int i = start; i < end; ++i) {
                    String py = _pyShow[_pyData[i] + tone];
                    if (list.contains(py)) continue;
                    list.add(py);
                }
            }
            return list;
        }
        return new ArrayList<String>();
    }

    public static String GetPinyinFast(Character c, int tone) throws NumberFormatException, IOException {
        PinyinDict.InitPyIndex();
        if (c.charValue() >= '\u3400' && c.charValue() <= '\u9fd5') {
            int index = c.charValue() - 13312;
            int start = _pyIndex[index];
            int end = _pyIndex[index + 1];
            if (end > start) {
                return _pyShow[_pyData[start] + tone];
            }
        }
        return c.toString();
    }

    public static List<String> GetPinyinForName(String name, int tone) throws NumberFormatException, IOException {
        String[] pys;
        String xing;
        PinyinDict.InitPyName();
        PinyinDict.InitPyIndex();
        ArrayList<String> list = new ArrayList<String>();
        if (name.length() > 1 && _pyName.containsKey(xing = name.substring(0, 2))) {
            Integer[] indexs;
            for (Integer index : indexs = _pyName.get(xing)) {
                list.add(_pyShow[index + tone]);
            }
            if (name.length() > 2) {
                String[] pys2;
                String ming = name.substring(2);
                for (String py : pys2 = PinyinDict.GetPinyinList(ming, tone)) {
                    list.add(py);
                }
            }
            return list;
        }
        xing = name.substring(0, 1);
        if (_pyName.containsKey(xing)) {
            Integer[] indexs = _pyName.get(xing);
            Object[] pys2 = indexs;
            int n = pys2.length;
            for (int i = 0; i < n; ++i) {
                Integer index = pys2[i];
                list.add(_pyShow[index + tone]);
            }
            if (name.length() > 1) {
                String ming = name.substring(1);
                for (Object py : pys2 = PinyinDict.GetPinyinList(ming, tone)) {
                    list.add((String)py);
                }
            }
            return list;
        }
        for (String py : pys = PinyinDict.GetPinyinList(name, tone)) {
            list.add(py);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyIndex() throws NumberFormatException, IOException {
        if (_pyIndex == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_pyIndex == null) {
                    String resourceName = "pyIndex.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1));
                    String tStr = "";
                    ArrayList<Integer> pyIndex = new ArrayList<Integer>();
                    pyIndex.add(0);
                    ArrayList<Integer> pyData = new ArrayList<Integer>();
                    while ((tStr = br.readLine()) != null) {
                        if (_pyShow == null) {
                            String[] ss = tStr.split(",");
                            _pyShow = ss;
                            continue;
                        }
                        if (tStr != "0") {
                            for (String idx : tStr.split(",")) {
                                int in = Integer.valueOf(idx, 16);
                                pyData.add(in);
                            }
                        }
                        pyIndex.add(pyData.size());
                    }
                    br.close();
                    Integer[] pd = new Integer[pyData.size()];
                    _pyData = pyData.toArray(pd);
                    Integer[] pi = new Integer[pyIndex.size()];
                    _pyIndex = pyIndex.toArray(pi);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyName() throws NumberFormatException, IOException {
        if (_pyName == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_pyName == null) {
                    String resourceName = "pyName.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1));
                    HashMap<String, Integer[]> pyName = new HashMap<String, Integer[]>();
                    String tStr = "";
                    while ((tStr = br.readLine()) != null) {
                        String[] sp = tStr.split(",");
                        ArrayList<Integer> index = new ArrayList<Integer>();
                        for (int i = 1; i < sp.length; ++i) {
                            String idx = sp[i];
                            int in = Integer.valueOf(idx, 16);
                            index.add(in);
                        }
                        Integer[] temp = new Integer[index.size()];
                        pyName.put(sp[0], index.toArray(temp));
                    }
                    br.close();
                    _pyName = pyName;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void InitPyWords() throws NumberFormatException, IOException {
        if (_search == null) {
            Object object = lockObj;
            synchronized (object) {
                if (_search == null) {
                    String resourceName = "pyWords.txt";
                    InputStream u1 = WordsSearch.class.getClassLoader().getResourceAsStream(resourceName);
                    BufferedReader br = new BufferedReader(new InputStreamReader(u1));
                    ArrayList<String> keywords = new ArrayList<String>();
                    ArrayList<Integer> wordPyIndex = new ArrayList<Integer>();
                    ArrayList<Integer> wordPy = new ArrayList<Integer>();
                    String tStr = "";
                    while ((tStr = br.readLine()) != null) {
                        String[] sp = tStr.split(",");
                        keywords.add(sp[0]);
                        wordPyIndex.add(wordPy.size());
                        for (int i = 1; i < sp.length; ++i) {
                            String idx = sp[i];
                            int in = Integer.valueOf(idx, 16);
                            wordPy.add(in);
                        }
                    }
                    br.close();
                    WordsSearch search = new WordsSearch();
                    search.SetKeywords(keywords);
                    Integer[] wp = new Integer[wordPy.size()];
                    _wordPy = wordPy.toArray(wp);
                    Integer[] wpi = new Integer[wordPyIndex.size()];
                    _wordPyIndex = wordPyIndex.toArray(wpi);
                    _search = search;
                }
            }
        }
    }

    static {
        lockObj = new Object();
    }
}

