/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import toolgood.words.NumHelper;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNodeEx;

public abstract class BaseSearchEx2 {
    protected String[] _keywords;
    protected int[][] _guides;
    protected int[] _key;
    protected int[] _next;
    protected int[] _check;
    protected int[] _dict;

    public void Save(String filePath) throws IOException {
        File fi = new File(filePath);
        FileOutputStream fs = new FileOutputStream(fi);
        this.Save(fs);
        fs.close();
    }

    protected void Save(FileOutputStream bw) throws IOException {
        bw.write(NumHelper.serialize(this._keywords.length));
        for (String item : this._keywords) {
            byte[] bytes = item.getBytes("utf-8");
            bw.write(NumHelper.serialize(bytes.length));
            bw.write(bytes);
        }
        bw.write(NumHelper.serialize(this._guides.length));
        for (int[] guide : this._guides) {
            bw.write(NumHelper.serialize(guide.length));
            for (int item : guide) {
                bw.write(NumHelper.serialize(item));
            }
        }
        bw.write(NumHelper.serialize(this._key.length));
        for (int item : this._key) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._next.length));
        for (int item : this._next) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._check.length));
        for (int item : this._check) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._dict.length));
        for (int item : this._dict) {
            bw.write(NumHelper.serialize(item));
        }
    }

    public void Load(String filePath) throws FileNotFoundException, IOException {
        File fi = new File(filePath);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fi));
        this.Load(in);
        ((InputStream)in).close();
    }

    public void Load(InputStream br) throws IOException {
        int i;
        int length = NumHelper.read(br);
        this._keywords = new String[length];
        for (i = 0; i < length; ++i) {
            int l = NumHelper.read(br);
            byte[] bytes = new byte[l];
            br.read(bytes, 0, l);
            this._keywords[i] = new String(bytes, "utf-8");
        }
        length = NumHelper.read(br);
        this._guides = new int[length][];
        for (i = 0; i < length; ++i) {
            int length2 = NumHelper.read(br);
            this._guides[i] = new int[length2];
            for (int j = 0; j < length2; ++j) {
                this._guides[i][j] = NumHelper.read(br);
            }
        }
        length = NumHelper.read(br);
        this._key = new int[length];
        for (i = 0; i < length; ++i) {
            this._key[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._next = new int[length];
        for (i = 0; i < length; ++i) {
            this._next[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._check = new int[length];
        for (i = 0; i < length; ++i) {
            this._check[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._dict = new int[length];
        for (i = 0; i < length; ++i) {
            this._dict[i] = NumHelper.read(br);
        }
    }

    public void SetKeywords(List<String> keywords) {
        this._keywords = keywords.toArray(new String[0]);
        this.SetKeywords();
    }

    private void SetKeywords() {
        int i;
        int i2;
        int j;
        TrieNode nd;
        TrieNode root = new TrieNode();
        TreeMap allNodeLayers = new TreeMap();
        for (int i3 = 0; i3 < this._keywords.length; ++i3) {
            String p = this._keywords[i3];
            nd = root;
            for (j = 0; j < p.length(); ++j) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer != 0) continue;
                nd.Layer = j + 1;
                if (!allNodeLayers.containsKey(nd.Layer)) {
                    ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                    nodes.add(nd);
                    allNodeLayers.put(nd.Layer, nodes);
                    continue;
                }
                ((List)allNodeLayers.get(nd.Layer)).add(nd);
            }
            nd.SetResults(i3);
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        for (i2 = 0; i2 < allNodeLayers.size(); ++i2) {
            List nodes = (List)allNodeLayers.get(i2 + 1);
            for (j = 0; j < nodes.size(); ++j) {
                allNode.add((TrieNode)nodes.get(j));
            }
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        for (i2 = 1; i2 < allNode.size(); ++i2) {
            nd = (TrieNode)allNode.get(i2);
            nd.Index = i2;
            TrieNode r = nd.Parent.Failure;
            Character c = Character.valueOf(nd.Char);
            while (r != null && !r.m_values.containsKey(c)) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
                continue;
            }
            nd.Failure = r.m_values.get(c);
            for (Integer result : nd.Failure.Results) {
                nd.SetResults(result);
            }
        }
        root.Failure = root;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i4 = 1; i4 < allNode.size(); ++i4) {
            stringBuilder.append(((TrieNode)allNode.get((int)i4)).Char);
        }
        Integer length = this.CreateDict(stringBuilder.toString());
        stringBuilder = null;
        ArrayList<TrieNodeEx> allNode2 = new ArrayList<TrieNodeEx>();
        for (i = 0; i < allNode.size(); ++i) {
            TrieNodeEx nd2 = new TrieNodeEx();
            nd2.Index = i;
            allNode2.add(nd2);
        }
        for (i = 0; i < allNode2.size(); ++i) {
            TrieNode nd3;
            TrieNode oldNode = (TrieNode)allNode.get(i);
            TrieNodeEx newNode = (TrieNodeEx)allNode2.get(i);
            newNode.Char = this._dict[oldNode.Char];
            for (Character key : oldNode.m_values.keySet()) {
                nd3 = oldNode.m_values.get(key);
                newNode.Add(this._dict[key.charValue()], (TrieNodeEx)allNode2.get(nd3.Index));
            }
            oldNode.Results.forEach(item -> newNode.SetResults((Integer)item));
            oldNode = oldNode.Failure;
            while (oldNode != root) {
                for (Character key : oldNode.m_values.keySet()) {
                    if (newNode.HasKey(this._dict[key.charValue()])) continue;
                    nd3 = oldNode.m_values.get(key);
                    newNode.Add(this._dict[key.charValue()], (TrieNodeEx)allNode2.get(nd3.Index));
                }
                oldNode.Results.forEach(item -> newNode.SetResults((Integer)item));
                oldNode = oldNode.Failure;
            }
        }
        allNode.clear();
        allNode = null;
        root = null;
        this.build(allNode2, length);
    }

    private void build(List<TrieNodeEx> nodes, int length) {
        int i;
        Object node;
        Integer[] has = new Integer[0xFFFFFF];
        boolean[] seats = new boolean[0xFFFFFF];
        boolean[] seats2 = new boolean[0xFFFFFF];
        Integer start = 1;
        Integer oneStart = 1;
        for (int i2 = 0; i2 < nodes.size(); ++i2) {
            node = nodes.get(i2);
            ((TrieNodeEx)node).Rank(oneStart, start, seats, seats2, has);
        }
        Integer maxCount = has.length - 1;
        while (has[maxCount] == null) {
            node = maxCount;
            maxCount = maxCount - 1;
        }
        length = maxCount + length + 1;
        this._key = new int[length];
        this._next = new int[length];
        this._check = new int[length];
        ArrayList<Integer[]> guides = new ArrayList<Integer[]>();
        guides.add(new Integer[]{0});
        for (i = 0; i < length; ++i) {
            if (has[i] == null) continue;
            TrieNodeEx item = nodes.get(has[i]);
            this._key[i] = item.Char;
            this._next[i] = item.Next;
            if (!item.End) continue;
            this._check[i] = guides.size();
            Integer[] result = item.Results.toArray(new Integer[0]);
            guides.add(result);
        }
        this._guides = new int[guides.size()][];
        for (i = 0; i < guides.size(); ++i) {
            Integer[] array = (Integer[])guides.get(i);
            this._guides[i] = new int[array.length];
            for (int j = 0; j < array.length; ++j) {
                this._guides[i][j] = array[j];
            }
        }
    }

    private int CreateDict(String keywords) {
        Hashtable<Character, Integer> dictionary = new Hashtable<Character, Integer>();
        for (int i = 0; i < keywords.length(); ++i) {
            Character item = Character.valueOf(keywords.charAt(i));
            if (dictionary.containsKey(item)) {
                dictionary.put(item, (Integer)dictionary.get(item) + 1);
                continue;
            }
            dictionary.put(item, 1);
        }
        Map dictionary2 = dictionary.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<Character> list2 = new ArrayList<Character>();
        for (Character item : dictionary2.keySet()) {
            list2.add(item);
        }
        this._dict = new int[65536];
        for (int i = 0; i < list2.size(); ++i) {
            this._dict[((Character)list2.get((int)i)).charValue()] = i + 1;
        }
        return dictionary.size();
    }
}

