/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words.internals;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import toolgood.words.NumHelper;
import toolgood.words.internals.IntDictionary;
import toolgood.words.internals.TrieNode;
import toolgood.words.internals.TrieNode2Ex;

public class BaseSearchEx {
    protected int[] _dict;
    protected int[] _first;
    protected int[] _min;
    protected int[] _max;
    protected IntDictionary[] _nextIndex;
    protected int[] _end;
    protected int[] _resultIndex;
    protected String[] _keywords;

    public void Save(String filePath) throws IOException {
        File fi = new File(filePath);
        FileOutputStream fs = new FileOutputStream(fi);
        this.Save(fs);
        fs.close();
    }

    /*
     * WARNING - void declaration
     */
    protected void Save(FileOutputStream bw) throws IOException {
        void var2_10;
        bw.write(NumHelper.serialize(this._keywords.length));
        for (String item : this._keywords) {
            byte[] bytes = item.getBytes("utf-8");
            bw.write(NumHelper.serialize(bytes.length));
            bw.write(bytes);
        }
        bw.write(NumHelper.serialize(this._dict.length));
        for (int item : this._dict) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._first.length));
        for (int item : this._first) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._min.length));
        for (int item : this._min) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._max.length));
        for (int item : this._max) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._end.length));
        for (int item : this._end) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._resultIndex.length));
        for (int item : this._resultIndex) {
            bw.write(NumHelper.serialize(item));
        }
        bw.write(NumHelper.serialize(this._nextIndex.length));
        boolean bl = false;
        while (var2_10 < this._nextIndex.length) {
            int[] keys = this._nextIndex[var2_10].getKeys();
            bw.write(NumHelper.serialize(keys.length));
            for (int item : keys) {
                bw.write(NumHelper.serialize(item));
            }
            int[] values = this._nextIndex[var2_10].getValues();
            bw.write(NumHelper.serialize(values.length));
            for (int item : values) {
                bw.write(NumHelper.serialize(item));
            }
            ++var2_10;
        }
    }

    public void Load(String filePath) throws FileNotFoundException, IOException {
        File fi = new File(filePath);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(fi));
        this.Load(in);
        ((InputStream)in).close();
    }

    public void Load(InputStream br) throws IOException {
        int i;
        int length = NumHelper.read(br);
        this._keywords = new String[length];
        for (i = 0; i < length; ++i) {
            int l = NumHelper.read(br);
            byte[] bytes = new byte[l];
            br.read(bytes, 0, l);
            this._keywords[i] = new String(bytes, "utf-8");
        }
        length = NumHelper.read(br);
        this._dict = new int[length];
        for (i = 0; i < length; ++i) {
            this._dict[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._first = new int[length];
        for (i = 0; i < length; ++i) {
            this._first[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._min = new int[length];
        for (i = 0; i < length; ++i) {
            this._min[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._max = new int[length];
        for (i = 0; i < length; ++i) {
            this._max[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._end = new int[length];
        for (i = 0; i < length; ++i) {
            this._end[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._resultIndex = new int[length];
        for (i = 0; i < length; ++i) {
            this._resultIndex[i] = NumHelper.read(br);
        }
        length = NumHelper.read(br);
        this._nextIndex = new IntDictionary[length];
        for (i = 0; i < length; ++i) {
            int l2 = NumHelper.read(br);
            int[] keys = new int[l2];
            for (int j = 0; j < keys.length; ++j) {
                keys[j] = NumHelper.read(br);
            }
            l2 = NumHelper.read(br);
            int[] values = new int[l2];
            for (int j = 0; j < values.length; ++j) {
                values[j] = NumHelper.read(br);
            }
            this._nextIndex[i] = new IntDictionary();
            this._nextIndex[i].SetDictionary(keys, values);
        }
    }

    public void SetKeywords(List<String> keywords) {
        this._keywords = keywords.toArray(new String[0]);
        this.SetKeywords();
    }

    private void SetKeywords() {
        int i;
        int j;
        TrieNode nd;
        TrieNode root = new TrieNode();
        TreeMap allNodeLayers = new TreeMap();
        for (int i3 = 0; i3 < this._keywords.length; ++i3) {
            String p = this._keywords[i3];
            nd = root;
            for (j = 0; j < p.length(); ++j) {
                nd = nd.Add(Character.valueOf(p.charAt(j)));
                if (nd.Layer != 0) continue;
                nd.Layer = j + 1;
                if (!allNodeLayers.containsKey(nd.Layer)) {
                    ArrayList<TrieNode> nodes = new ArrayList<TrieNode>();
                    nodes.add(nd);
                    allNodeLayers.put(nd.Layer, nodes);
                    continue;
                }
                ((List)allNodeLayers.get(nd.Layer)).add(nd);
            }
            nd.SetResults(i3);
        }
        ArrayList<TrieNode> allNode = new ArrayList<TrieNode>();
        allNode.add(root);
        for (int i2 = 0; i2 < allNodeLayers.size(); ++i2) {
            List nodes = (List)allNodeLayers.get(i2 + 1);
            for (j = 0; j < nodes.size(); ++j) {
                allNode.add((TrieNode)nodes.get(j));
            }
        }
        allNodeLayers.clear();
        allNodeLayers = null;
        for (int i2 = 1; i2 < allNode.size(); ++i2) {
            nd = (TrieNode)allNode.get(i2);
            nd.Index = i2;
            TrieNode r = nd.Parent.Failure;
            Character c = Character.valueOf(nd.Char);
            while (r != null && !r.m_values.containsKey(c)) {
                r = r.Failure;
            }
            if (r == null) {
                nd.Failure = root;
                continue;
            }
            nd.Failure = r.m_values.get(c);
            for (Integer n : nd.Failure.Results) {
                nd.SetResults(n);
            }
        }
        root.Failure = root;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i4 = 1; i4 < allNode.size(); ++i4) {
            stringBuilder.append(((TrieNode)allNode.get((int)i4)).Char);
        }
        this.CreateDict(stringBuilder.toString());
        stringBuilder = null;
        ArrayList<TrieNode2Ex> allNode2 = new ArrayList<TrieNode2Ex>();
        int i5 = 0;
        while (i5 < allNode.size()) {
            TrieNode2Ex nd2 = new TrieNode2Ex();
            nd2.Index = i5++;
            allNode2.add(nd2);
        }
        for (int i3 = 0; i3 < allNode2.size(); ++i3) {
            TrieNode oldNode = (TrieNode)allNode.get(i3);
            TrieNode2Ex newNode = (TrieNode2Ex)allNode2.get(i3);
            for (Character key : oldNode.m_values.keySet()) {
                TrieNode nd3 = oldNode.m_values.get(key);
                newNode.Add(this._dict[key.charValue()], (TrieNode2Ex)allNode2.get(nd3.Index));
            }
            oldNode.Results.forEach(item -> newNode.SetResults((int)item));
            oldNode = oldNode.Failure;
            while (oldNode != root) {
                for (Character key : oldNode.m_values.keySet()) {
                    if (newNode.HasKey(this._dict[key.charValue()])) continue;
                    TrieNode nd2 = oldNode.m_values.get(key);
                    newNode.Add(this._dict[key.charValue()], (TrieNode2Ex)allNode2.get(nd2.Index));
                }
                oldNode.Results.forEach(item -> newNode.SetResults((int)item));
                oldNode = oldNode.Failure;
            }
        }
        allNode.clear();
        allNode = null;
        root = null;
        ArrayList<Integer> min = new ArrayList<Integer>();
        ArrayList<Integer> max = new ArrayList<Integer>();
        ArrayList<Object> nextIndexs = new ArrayList<Object>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(0);
        ArrayList<Integer> resultIndex = new ArrayList<Integer>();
        for (int i6 = 0; i6 < allNode2.size(); ++i6) {
            TreeMap dict = new TreeMap();
            TrieNode2Ex node = (TrieNode2Ex)allNode2.get(i6);
            min.add(node.minflag);
            max.add(node.maxflag);
            if (i6 > 0) {
                for (Integer key : node.m_values.keySet()) {
                    dict.put(key, node.m_values.get((Object)key).Index);
                }
            }
            for (int j2 = 0; j2 < node.Results.size(); ++j2) {
                resultIndex.add(node.Results.get(j2));
            }
            arrayList.add(resultIndex.size());
            nextIndexs.add(dict);
        }
        int[] first = new int[65536];
        for (Integer key : ((TrieNode2Ex)allNode2.get((int)0)).m_values.keySet()) {
            TrieNode2Ex nd4 = ((TrieNode2Ex)allNode2.get((int)0)).m_values.get(key);
            first[key.intValue()] = nd4.Index;
        }
        this._first = first;
        this._min = new int[min.size()];
        this._max = new int[min.size()];
        for (i = 0; i < min.size(); ++i) {
            this._min[i] = (Integer)min.get(i);
            this._max[i] = (Integer)max.get(i);
        }
        this._nextIndex = new IntDictionary[nextIndexs.size()];
        for (i = 0; i < nextIndexs.size(); ++i) {
            IntDictionary dictionary = new IntDictionary();
            dictionary.SetDictionary((Map)nextIndexs.get(i));
            this._nextIndex[i] = dictionary;
        }
        this._end = new int[arrayList.size()];
        for (i = 0; i < arrayList.size(); ++i) {
            this._end[i] = (Integer)arrayList.get(i);
        }
        this._resultIndex = new int[resultIndex.size()];
        for (i = 0; i < resultIndex.size(); ++i) {
            this._resultIndex[i] = (Integer)resultIndex.get(i);
        }
        allNode2.clear();
        allNode2 = null;
    }

    private int CreateDict(String keywords) {
        Hashtable<Character, Integer> dictionary = new Hashtable<Character, Integer>();
        for (int i = 0; i < keywords.length(); ++i) {
            Character item = Character.valueOf(keywords.charAt(i));
            if (dictionary.containsKey(item)) {
                dictionary.put(item, (Integer)dictionary.get(item) + 1);
                continue;
            }
            dictionary.put(item, 1);
        }
        Map dictionary2 = dictionary.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        ArrayList<Character> list2 = new ArrayList<Character>();
        for (Character item : dictionary2.keySet()) {
            list2.add(item);
        }
        this._dict = new int[65536];
        for (int i = 0; i < list2.size(); ++i) {
            this._dict[((Character)list2.get((int)i)).charValue()] = i + 1;
        }
        return dictionary.size();
    }
}

