/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.util.ArrayList;
import java.util.List;
import toolgood.words.WordsSearchResult;
import toolgood.words.internals.BaseMatch;
import toolgood.words.internals.TrieNode3;

public class WordsMatch
extends BaseMatch {
    public WordsSearchResult FindFirst(String text) {
        TrieNode3 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            Integer r;
            int length;
            int start;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                WordsSearchResult result;
                if (ptr.HasWildcard && (result = this.FindFirst(text, i + 1, ptr.WildcardNode)) != null) {
                    return result;
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (start = i - (length = this._keywordLength[r = tn.Results.get(0)]) + 1) >= 0) {
                int kIndex = this._keywordIndex[r];
                String matchKeyword = this._matchKeywords[kIndex];
                String keyword = text.substring(start, i + 1);
                return new WordsSearchResult(keyword, start, i, kIndex, matchKeyword);
            }
            ptr = tn;
        }
        return null;
    }

    private WordsSearchResult FindFirst(String text, int index, TrieNode3 ptr) {
        for (int i = index; i < text.length(); ++i) {
            Integer r;
            int length;
            int start;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                WordsSearchResult result;
                if (ptr.HasWildcard && (result = this.FindFirst(text, i + 1, ptr.WildcardNode)) != null) {
                    return result;
                }
                return null;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (start = i - (length = this._keywordLength[r = tn.Results.get(0)]) + 1) >= 0) {
                int kIndex = this._keywordIndex[r];
                String matchKeyword = this._matchKeywords[kIndex];
                String keyword = text.substring(start, i + 1);
                return new WordsSearchResult(keyword, start, i, kIndex, matchKeyword);
            }
            ptr = tn;
        }
        return null;
    }

    public List<WordsSearchResult> FindAll(String text) {
        TrieNode3 ptr = null;
        ArrayList<WordsSearchResult> result = new ArrayList<WordsSearchResult>();
        for (int i = 0; i < text.length(); ++i) {
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.FindAll(text, i + 1, ptr.WildcardNode, result);
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End) {
                for (Integer r : tn.Results) {
                    int length = this._keywordLength[r];
                    int start = i - length + 1;
                    if (start < 0) continue;
                    int kIndex = this._keywordIndex[r];
                    String matchKeyword = this._matchKeywords[kIndex];
                    String keyword = text.substring(start, i + 1);
                    WordsSearchResult wr = new WordsSearchResult(keyword, start, i, kIndex, matchKeyword);
                    result.add(wr);
                }
            }
            ptr = tn;
        }
        return result;
    }

    private void FindAll(String text, int index, TrieNode3 ptr, List<WordsSearchResult> result) {
        for (int i = index; i < text.length(); ++i) {
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.FindAll(text, i + 1, ptr.WildcardNode, result);
                }
                return;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End) {
                for (Integer r : tn.Results) {
                    int length = this._keywordLength[r];
                    int start = i - length + 1;
                    if (start < 0) continue;
                    int kIndex = this._keywordIndex[r];
                    String matchKeyword = this._matchKeywords[kIndex];
                    String keyword = text.substring(start, i + 1);
                    WordsSearchResult wr = new WordsSearchResult(keyword, start, i, kIndex, matchKeyword);
                    result.add(wr);
                }
            }
            ptr = tn;
        }
    }

    public boolean ContainsAny(String text) {
        TrieNode3 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            int length;
            int s;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                boolean result;
                if (ptr.HasWildcard && (result = this.ContainsAny(text, i + 1, ptr.WildcardNode))) {
                    return true;
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return true;
            }
            ptr = tn;
        }
        return false;
    }

    private boolean ContainsAny(String text, int index, TrieNode3 ptr) {
        for (int i = index; i < text.length(); ++i) {
            int length;
            int s;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    return this.ContainsAny(text, i + 1, ptr.WildcardNode);
                }
                return false;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (s = i - (length = this._keywordLength[tn.Results.get(0)]) + 1) >= 0) {
                return true;
            }
            ptr = tn;
        }
        return false;
    }

    public String Replace(String text) {
        return this.Replace(text, '*');
    }

    public String Replace(String text, char replaceChar) {
        StringBuilder result = new StringBuilder(text);
        TrieNode3 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            int maxLength;
            int start;
            TrieNode3 tn;
            char t = text.charAt(i);
            if (ptr == null) {
                tn = this._first[t];
            } else if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.Replace(text, i + 1, ptr.WildcardNode, replaceChar, result);
                }
                tn = this._first[t];
            } else {
                tn = ptr.GetValue(t);
            }
            if (tn != null && tn.End && (start = i + 1 - (maxLength = this._keywordLength[tn.Results.get(0)])) >= 0) {
                for (int j = start; j <= i; ++j) {
                    result.setCharAt(j, replaceChar);
                }
            }
            ptr = tn;
        }
        return result.toString();
    }

    private void Replace(String text, int index, TrieNode3 ptr, char replaceChar, StringBuilder result) {
        for (int i = index; i < text.length(); ++i) {
            int maxLength;
            int start;
            char t = text.charAt(i);
            if (!ptr.HasKey(t)) {
                if (ptr.HasWildcard) {
                    this.Replace(text, i + 1, ptr.WildcardNode, replaceChar, result);
                }
                return;
            }
            TrieNode3 tn = ptr.GetValue(t);
            if (tn.End && (start = i + 1 - (maxLength = this._keywordLength[tn.Results.get(0)])) >= 0) {
                for (int j = start; j <= i; ++j) {
                    result.setCharAt(j, replaceChar);
                }
            }
            ptr = tn;
        }
    }
}

