/*
 * Decompiled with CFR 0.152.
 */
package toolgood.words;

import java.util.ArrayList;
import java.util.List;
import toolgood.words.internals.BaseSearch;
import toolgood.words.internals.TrieNode2;

public class StringSearch
extends BaseSearch {
    public String FindFirst(String text) {
        TrieNode2 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                return this._keywords[tn.Results.get(0)];
            }
            ptr = tn;
        }
        return null;
    }

    public List<String> FindAll(String text) {
        TrieNode2 ptr = null;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < text.length(); ++i) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                tn.Results.forEach(item -> list.add(this._keywords[item]));
            }
            ptr = tn;
        }
        return list;
    }

    public boolean ContainsAny(String text) {
        TrieNode2 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                return true;
            }
            ptr = tn;
        }
        return false;
    }

    public String Replace(String text) {
        return this.Replace(text, '*');
    }

    public String Replace(String text, char replaceChar) {
        StringBuilder result = new StringBuilder(text);
        TrieNode2 ptr = null;
        for (int i = 0; i < text.length(); ++i) {
            char t = text.charAt(i);
            TrieNode2 tn = null;
            tn = ptr == null ? this._first[t] : (!ptr.HasKey(t) ? this._first[t] : ptr.GetValue(t));
            if (tn != null && tn.End) {
                int start;
                int maxLength = this._keywords[tn.Results.get(0)].length();
                for (int j = start = i + 1 - maxLength; j <= i; ++j) {
                    result.setCharAt(j, replaceChar);
                }
            }
            ptr = tn;
        }
        return result.toString();
    }
}

