/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.util;

import io.github.toolfactory.jvm.function.template.Function;
import java.nio.ByteBuffer;

public class Classes {
    public static boolean isAssignableFrom(Class<?> cls_01, Class<?> cls_02) {
        return Classes.getClassOrWrapper(cls_01).isAssignableFrom(Classes.getClassOrWrapper(cls_02));
    }

    public static Class<?> getClassOrWrapper(Class<?> cls) {
        if (cls.isPrimitive()) {
            if (cls == Short.TYPE) {
                return Short.class;
            }
            if (cls == Integer.TYPE) {
                return Integer.class;
            }
            if (cls == Long.TYPE) {
                return Long.class;
            }
            if (cls == Float.TYPE) {
                return Float.class;
            }
            if (cls == Double.TYPE) {
                return Double.class;
            }
            if (cls == Boolean.TYPE) {
                return Boolean.class;
            }
            if (cls == Byte.TYPE) {
                return Byte.class;
            }
            if (cls == Character.TYPE) {
                return Character.class;
            }
        }
        return cls;
    }

    public static class File {

        public static class Reader {
            public static RawInfo retrieveInfo(final byte[] classFileBuffer) {
                return Reader.retrieveInfo(new Function<Integer, Byte>(){

                    @Override
                    public Byte apply(Integer index) {
                        return classFileBuffer[index];
                    }
                });
            }

            public static RawInfo retrieveInfo(final ByteBuffer classFileBuffer) {
                return Reader.retrieveInfo(new Function<Integer, Byte>(){

                    @Override
                    public Byte apply(Integer index) {
                        return classFileBuffer.get(index);
                    }
                });
            }

            private static RawInfo retrieveInfo(Function<Integer, Byte> byteSupplier) {
                int classFileOffset = 0;
                int constantPoolCount = Reader.readUnsignedShort(byteSupplier, classFileOffset + 8);
                int[] cpInfoOffsets = new int[constantPoolCount];
                String[] constantUtf8Values = new String[constantPoolCount];
                int currentCpInfoIndex = 1;
                int currentCpInfoOffset = classFileOffset + 10;
                int currentMaxStringLength = 0;
                while (currentCpInfoIndex < constantPoolCount) {
                    int cpInfoSize;
                    cpInfoOffsets[currentCpInfoIndex++] = currentCpInfoOffset + 1;
                    byte currentCpInfoValue = byteSupplier.apply(currentCpInfoOffset);
                    if (currentCpInfoValue == 3 || currentCpInfoValue == 4 || currentCpInfoValue == 9 || currentCpInfoValue == 10 || currentCpInfoValue == 11 || currentCpInfoValue == 12 || currentCpInfoValue == 17 || currentCpInfoValue == 18) {
                        cpInfoSize = 5;
                    } else if (currentCpInfoValue == 5 || currentCpInfoValue == 6) {
                        cpInfoSize = 9;
                        ++currentCpInfoIndex;
                    } else if (currentCpInfoValue == 1) {
                        cpInfoSize = 3 + Reader.readUnsignedShort(byteSupplier, currentCpInfoOffset + 1);
                        if (cpInfoSize > currentMaxStringLength) {
                            currentMaxStringLength = cpInfoSize;
                        }
                    } else if (currentCpInfoValue == 15) {
                        cpInfoSize = 4;
                    } else if (currentCpInfoValue == 7 || currentCpInfoValue == 8 || currentCpInfoValue == 16 || currentCpInfoValue == 19 || currentCpInfoValue == 20) {
                        cpInfoSize = 3;
                    } else {
                        throw new IllegalArgumentException();
                    }
                    currentCpInfoOffset += cpInfoSize;
                }
                int maxStringLength = currentMaxStringLength;
                int header = currentCpInfoOffset;
                int modifiers = Reader.readUnsignedShort(byteSupplier, header);
                if ((modifiers & 0x8000) == 0) {
                    return new RawInfo(modifiers, Reader.readUTF8(byteSupplier, cpInfoOffsets[Reader.readUnsignedShort(byteSupplier, header + 2)], new char[maxStringLength], constantUtf8Values, cpInfoOffsets), Reader.readUTF8(byteSupplier, cpInfoOffsets[Reader.readUnsignedShort(byteSupplier, header + 4)], new char[maxStringLength], constantUtf8Values, cpInfoOffsets), Reader.getInterfaceNames(byteSupplier, header, maxStringLength, constantUtf8Values, cpInfoOffsets));
                }
                return null;
            }

            private static String[] getInterfaceNames(Function<Integer, Byte> byteSupplier, int header, int maxStringLength, String[] constantUtf8Values, int[] cpInfoOffsets) {
                int currentOffset = header + 6;
                int interfacesCount = Reader.readUnsignedShort(byteSupplier, currentOffset);
                String[] interfaces = new String[interfacesCount];
                if (interfacesCount > 0) {
                    char[] charBuffer = new char[maxStringLength];
                    for (int i = 0; i < interfacesCount; ++i) {
                        interfaces[i] = Reader.readUTF8(byteSupplier, cpInfoOffsets[Reader.readUnsignedShort(byteSupplier, currentOffset += 2)], charBuffer, constantUtf8Values, cpInfoOffsets);
                    }
                }
                return interfaces;
            }

            private static String readUTF8(Function<Integer, Byte> byteSupplier, int offset, char[] charBuffer, String[] constantUtf8Values, int[] cpInfoOffsets) {
                int constantPoolEntryIndex = Reader.readUnsignedShort(byteSupplier, offset);
                if (offset == 0 || constantPoolEntryIndex == 0) {
                    return null;
                }
                return Reader.readUtf(byteSupplier, constantPoolEntryIndex, charBuffer, constantUtf8Values, cpInfoOffsets);
            }

            private static String readUtf(Function<Integer, Byte> byteSupplier, int constantPoolEntryIndex, char[] charBuffer, String[] constantUtf8Values, int[] cpInfoOffsets) {
                String value = constantUtf8Values[constantPoolEntryIndex];
                if (value != null) {
                    return value;
                }
                int cpInfoOffset = cpInfoOffsets[constantPoolEntryIndex];
                constantUtf8Values[constantPoolEntryIndex] = Reader.readUtf(byteSupplier, cpInfoOffset + 2, Reader.readUnsignedShort(byteSupplier, cpInfoOffset), charBuffer);
                return constantUtf8Values[constantPoolEntryIndex];
            }

            private static int readUnsignedShort(Function<Integer, Byte> byteSupplier, int offset) {
                return (byteSupplier.apply(offset) & 0xFF) << 8 | byteSupplier.apply(offset + 1) & 0xFF;
            }

            private static String readUtf(Function<Integer, Byte> byteSupplier, int utfOffset, int utfLength, char[] charBuffer) {
                int currentOffset = utfOffset;
                int endOffset = currentOffset + utfLength;
                int strLength = 0;
                while (currentOffset < endOffset) {
                    byte currentByte;
                    if (((currentByte = byteSupplier.apply(currentOffset++).byteValue()) & 0x80) == 0) {
                        charBuffer[strLength++] = (char)(currentByte & 0x7F);
                        continue;
                    }
                    if ((currentByte & 0xE0) == 192) {
                        charBuffer[strLength++] = (char)(((currentByte & 0x1F) << 6) + (byteSupplier.apply(currentOffset++) & 0x3F));
                        continue;
                    }
                    charBuffer[strLength++] = (char)(((currentByte & 0xF) << 12) + ((byteSupplier.apply(currentOffset++) & 0x3F) << 6) + (byteSupplier.apply(currentOffset++) & 0x3F));
                }
                return new String(charBuffer, 0, strLength);
            }
        }

        private static class Symbol {
            private Symbol() {
            }

            static class Tag {
                static final byte UTF8 = 1;
                static final byte INTEGER = 3;
                static final byte FLOAT = 4;
                static final byte LONG = 5;
                static final byte DOUBLE = 6;
                static final byte CLASS = 7;
                static final byte STRING = 8;
                static final byte FIELD_REF = 9;
                static final byte METHOD_REF = 10;
                static final byte INTERFACE_METHOD_REF = 11;
                static final byte NAME_AND_TYPE = 12;
                static final byte METHOD_HANDLE = 15;
                static final byte METHOD_TYPE = 16;
                static final byte DYNAMIC = 17;
                static final byte INVOKE_DYNAMIC = 18;
                static final byte MODULE = 19;
                static final byte PACKAGE = 20;

                Tag() {
                }
            }
        }
    }

    public static class RawInfo {
        int modifiers;
        String name;
        String superClassName;
        String[] interfaceNames;

        private RawInfo(int modifiers, String rawName, String superClassRawName, String[] implementedInterfaceRawNames) {
            this.modifiers = modifiers;
            this.name = rawName;
            this.superClassName = superClassRawName;
            this.interfaceNames = implementedInterfaceRawNames;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public String getName() {
            return this.name;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public String[] getInterfaceNames() {
            return this.interfaceNames;
        }
    }
}

