/*
 * Decompiled with CFR 0.152.
 */
package io.github.technologize.log4j.appender.fluentd;

import java.net.InetSocketAddress;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="Server", category="Core", elementType="sever", printObject=true)
public class Server {
    public static final String PLUGIN_NAME = "Server";
    public static final String ELEMENT_TYPE = "sever";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final InetSocketAddress address;

    private Server(String host, int port) {
        this.address = new InetSocketAddress(host, port);
    }

    @PluginFactory
    public static Server createServer(@PluginAttribute(value="host") @Required(message="Property host cannot be null") String host, @PluginAttribute(value="port") @Required(message="Property port must be > 0") int port) {
        if (host == null) {
            LOGGER.error("Property host cannot be null");
        }
        if (port <= 0) {
            LOGGER.error("Property port must be > 0");
        }
        return new Server(host, port);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }
}

