/*
 * Decompiled with CFR 0.152.
 */
package io.github.technologize.log4j.appender.fluentd;

import io.github.technologize.log4j.appender.fluency.core.FluencyConfig;
import io.github.technologize.log4j.appender.fluentd.Server;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.util.Assert;
import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.fluentd.FluencyBuilderForFluentd;

@Plugin(name="FluentdConfig", category="Core", elementType="config", printObject=true)
public class FluentdConfig
implements FluencyConfig {
    public static final String PLUGIN_TYPE = "FluentdConfig";
    private Server[] servers;
    private FluencyBuilderForFluentd fluencyBuilder;

    @PluginFactory
    public static FluentdConfig createFluencyConfig(@PluginElement(value="sever") Server[] servers, @PluginAttribute(value="maxBufferSize", defaultLong=0x20000000L) long maxBufferSize, @PluginAttribute(value="bufferChunkInitialSize", defaultInt=0x100000) int bufferChunkInitialSize, @PluginAttribute(value="bufferChunkRetentionSize", defaultInt=0x400000) int bufferChunkRetentionSize, @PluginAttribute(value="bufferChunkRetentionTimeMillis", defaultInt=1000) int bufferChunkRetentionTimeMillis, @PluginAttribute(value="flushAttemptIntervalMillis", defaultInt=600) int flushAttemptIntervalMillis, @PluginAttribute(value="waitUntilBufferFlushed", defaultInt=10) int waitUntilBufferFlushed, @PluginAttribute(value="waitUntilFlusherTerminated", defaultInt=10) int waitUntilFlusherTerminated, @PluginAttribute(value="senderMaxRetryCount", defaultInt=8) int senderMaxRetryCount, @PluginAttribute(value="senderBaseRetryIntervalMillis", defaultInt=400) int senderBaseRetryIntervalMillis, @PluginAttribute(value="senderMaxRetryIntervalMillis", defaultInt=30000) int senderMaxRetryIntervalMillis, @PluginAttribute(value="connectionTimeoutMillis", defaultInt=5000) int connectionTimeoutMillis, @PluginAttribute(value="readTimeoutMillis", defaultInt=5000) int readTimeoutMillis, @PluginAttribute(value="ackResponseMode") boolean ackResponseMode, @PluginAttribute(value="sslEnabled") boolean sslEnabled, @PluginAttribute(value="jvmHeapBufferMode", defaultBoolean=true) boolean jvmHeapBufferMode, @PluginAttribute(value="fileBackupDir") String fileBackupDir) {
        FluentdConfig config = new FluentdConfig();
        config.servers = servers;
        FluencyBuilderForFluentd builder = config.fluencyBuilder = new FluencyBuilderForFluentd();
        builder.setMaxBufferSize(Long.valueOf(maxBufferSize));
        builder.setBufferChunkInitialSize(Integer.valueOf(bufferChunkInitialSize));
        builder.setBufferChunkRetentionSize(Integer.valueOf(bufferChunkRetentionSize));
        builder.setBufferChunkRetentionTimeMillis(Integer.valueOf(bufferChunkRetentionTimeMillis));
        builder.setFlushAttemptIntervalMillis(Integer.valueOf(flushAttemptIntervalMillis));
        builder.setWaitUntilBufferFlushed(Integer.valueOf(waitUntilBufferFlushed));
        builder.setWaitUntilFlusherTerminated(Integer.valueOf(waitUntilFlusherTerminated));
        builder.setSenderMaxRetryCount(Integer.valueOf(senderMaxRetryCount));
        builder.setSenderBaseRetryIntervalMillis(Integer.valueOf(senderBaseRetryIntervalMillis));
        builder.setSenderMaxRetryIntervalMillis(Integer.valueOf(senderMaxRetryIntervalMillis));
        builder.setConnectionTimeoutMilli(Integer.valueOf(connectionTimeoutMillis));
        builder.setReadTimeoutMilli(Integer.valueOf(readTimeoutMillis));
        builder.setAckResponseMode(ackResponseMode);
        builder.setSslEnabled(sslEnabled);
        builder.setJvmHeapBufferMode(Boolean.valueOf(jvmHeapBufferMode));
        builder.setFileBackupDir(fileBackupDir);
        return config;
    }

    public Fluency makeFluency() {
        FluencyBuilderForFluentd builder;
        FluencyBuilderForFluentd fluencyBuilderForFluentd = builder = Objects.nonNull(this.fluencyBuilder) ? this.fluencyBuilder : new FluencyBuilderForFluentd();
        if (Assert.isNonEmpty((Object)this.servers)) {
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (Server server : this.servers) {
                addresses.add(server.getAddress());
            }
            return builder.build(addresses);
        }
        return builder.build();
    }
}

