/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.codeprovider.decorator;

import eu.solven.cleanthat.codeprovider.decorator.IGitReference;
import eu.solven.cleanthat.codeprovider.decorator.ILazyGitReference;
import java.util.function.Supplier;

public class LazyGitReference
implements ILazyGitReference {
    final String gitRef;
    final Supplier<IGitReference> supplier;

    public LazyGitReference(String gitRef, Supplier<IGitReference> supplier) {
        this.gitRef = gitRef;
        this.supplier = supplier;
    }

    @Override
    public String getFullRefOrSha1() {
        return this.gitRef;
    }

    @Override
    public Supplier<IGitReference> getSupplier() {
        return () -> {
            String lazyRef;
            IGitReference reference = this.supplier.get();
            String initialRef = this.getFullRefOrSha1();
            if (!initialRef.equals(lazyRef = reference.getFullRefOrSha1())) {
                throw new IllegalStateException("Inconsistency: " + initialRef + " vs " + lazyRef);
            }
            return reference;
        };
    }
}

