/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AtomicLongMap;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.config.EngineInitializerResult;
import eu.solven.cleanthat.config.IncludeExcludeHelpers;
import eu.solven.cleanthat.config.pojo.CleanthatEngineProperties;
import eu.solven.cleanthat.config.pojo.CleanthatRepositoryProperties;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.cleanthat.engine.IEngineStep;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateInitialConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerateInitialConfig.class);
    final Collection<IEngineLintFixerFactory> factories;

    public GenerateInitialConfig(Collection<IEngineLintFixerFactory> factories) {
        this.factories = factories;
    }

    public EngineInitializerResult prepareDefaultConfiguration(ICodeProvider codeProvider) throws IOException {
        LinkedHashMap pathToContent = new LinkedHashMap();
        CleanthatRepositoryProperties properties = CleanthatRepositoryProperties.defaultRepository();
        ArrayList mutableEngines = new ArrayList(properties.getEngines());
        properties.setEngines(mutableEngines);
        AtomicLongMap<String> factoryToFileCount = this.scanFileExtentions(codeProvider, this.factories, IEngineLintFixerFactory::getEngine, IEngineLintFixerFactory::getDefaultIncludes);
        factoryToFileCount.asMap().forEach((engine, count) -> {
            if (count == 0L) {
                LOGGER.info("Not a single file matched {}", engine);
            } else {
                LOGGER.info("Some files ({}) matched {}", count, engine);
                IEngineLintFixerFactory factory = this.factories.stream().filter(f -> engine.equals(f.getEngine())).findAny().get();
                AtomicLongMap<String> stepToFileCount = this.scanFileExtentions(codeProvider, factory.getMainSteps(), IEngineStep::getStep, IEngineStep::getDefaultIncludes);
                Set<String> subStepIds = stepToFileCount.asMap().keySet();
                LOGGER.info("We accept subStepIds={} for {}", subStepIds, engine);
                CleanthatEngineProperties engineProperties = factory.makeDefaultProperties(subStepIds);
                mutableEngines.add(engineProperties);
                pathToContent.putAll(factory.makeCustomDefaultFiles(engineProperties, subStepIds));
            }
        });
        return EngineInitializerResult.builder().repoProperties(properties).pathToContents(pathToContent).build();
    }

    public <T> AtomicLongMap<String> scanFileExtentions(ICodeProvider codeProvider, Collection<T> factories, Function<T, String> getId, Function<T, Set<String>> getDefaultIncludes) {
        AtomicLongMap factoryToFileCount = AtomicLongMap.create();
        Path repoRoot = codeProvider.getRepositoryRoot();
        try {
            LOGGER.info("About to list files to prepare a default configuration");
            HashSet allIncludes = new HashSet();
            factories.forEach(f -> allIncludes.addAll((Collection)getDefaultIncludes.apply(f)));
            codeProvider.listFilesForFilenames(allIncludes, file -> {
                Path filePath = file.getPath();
                factories.forEach(factory -> {
                    Set includes = (Set)getDefaultIncludes.apply(factory);
                    List includeMatchers = IncludeExcludeHelpers.prepareMatcher((FileSystem)repoRoot.getFileSystem(), (Collection)includes);
                    Optional matchingInclude = IncludeExcludeHelpers.findMatching((List)includeMatchers, (Path)filePath);
                    if (matchingInclude.isPresent()) {
                        factoryToFileCount.getAndIncrement((Object)((String)getId.apply(factory)));
                    }
                });
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue listing all files for extentions", e);
        }
        catch (OutOfMemoryError e) {
            LOGGER.warn("Issue while processing the repository", (Throwable)e);
        }
        LOGGER.info("Extentions found in {}: {}", (Object)codeProvider, (Object)factoryToFileCount);
        return factoryToFileCount;
    }
}

