/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.solven.cleanthat.code_provider.CleanthatPathHelpers;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.config.EngineInitializerResult;
import eu.solven.cleanthat.config.GenerateInitialConfig;
import eu.solven.cleanthat.config.ICleanthatConfigInitializer;
import eu.solven.cleanthat.config.RepoInitializerResult;
import eu.solven.cleanthat.engine.IEngineLintFixerFactory;
import eu.solven.pepper.resource.PepperResourceHelper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.regex.Pattern;

public class CleanthatConfigInitializer
implements ICleanthatConfigInitializer {
    public static final String TEMPLATES_FOLDER = "/templates";
    public static final String REF_TO_BLACELLE = "@solven-eu/cleanthat-notify please look at me";
    final ObjectMapper objectMapper;
    final Collection<IEngineLintFixerFactory> factories;

    public CleanthatConfigInitializer(ObjectMapper objectMapper, Collection<IEngineLintFixerFactory> factories) {
        this.objectMapper = objectMapper;
        this.factories = factories;
    }

    @Override
    public RepoInitializerResult prepareFile(ICodeProvider codeProvider, boolean isPrivate, String eventKey) {
        String defaultRepoPropertiesPath = ".cleanthat/cleanthat.yaml";
        Object body = PepperResourceHelper.loadAsString((String)"/templates/onboarding-body.md");
        body = ((String)body).replaceAll(Pattern.quote("${DEFAULT_PATH}"), defaultRepoPropertiesPath);
        body = ((String)body).replaceAll(Pattern.quote("${EVENT_SOURCE}"), "X-GitHub-Delivery");
        body = ((String)body).replaceAll(Pattern.quote("${EVENT_ID}"), eventKey);
        if (!isPrivate) {
            body = (String)body + "\r\n---\r\n@solven-eu/cleanthat-notify please look at me";
        }
        String commitMessage = PepperResourceHelper.loadAsString((String)"/templates/commit-message.txt");
        RepoInitializerResult.RepoInitializerResultBuilder resultBuilder = RepoInitializerResult.builder().prBody((String)body).commitMessage(commitMessage);
        GenerateInitialConfig generateInitialConfig = new GenerateInitialConfig(this.factories);
        try {
            EngineInitializerResult engineConfig = generateInitialConfig.prepareDefaultConfiguration(codeProvider);
            String repoPropertiesYaml = this.objectMapper.writeValueAsString((Object)engineConfig.getRepoProperties());
            Path repositoryRoot = codeProvider.getRepositoryRoot();
            resultBuilder.pathToContent(CleanthatPathHelpers.makeContentPath((Path)repositoryRoot, (String)defaultRepoPropertiesPath), repoPropertiesYaml);
            engineConfig.getPathToContents().forEach((k, v) -> resultBuilder.pathToContent(CleanthatPathHelpers.makeContentPath((Path)repositoryRoot, (String)k), (String)v));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Issue preparing initial config given codeProvider=" + codeProvider, e);
        }
        return resultBuilder.build();
    }
}

