/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.formatter;

import com.google.common.base.Suppliers;
import eu.solven.cleanthat.code_provider.CleanthatPathHelpers;
import java.nio.file.Path;
import java.util.function.Supplier;

public class PathAndContent {
    final Path path;
    final Supplier<String> contentSupplier;

    public PathAndContent(Path path, Supplier<String> contentSupplier) {
        CleanthatPathHelpers.checkContentPath(path);
        this.path = path;
        this.contentSupplier = Suppliers.memoize(contentSupplier::get);
    }

    public PathAndContent(Path path, String content) {
        this(path, () -> content);
    }

    public Path getPath() {
        return this.path;
    }

    public String getContent() {
        return this.contentSupplier.get();
    }

    public PathAndContent withContent(String newContent) {
        return new PathAndContent(this.getPath(), () -> newContent);
    }
}

