/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.containers.database;

import io.github.snowdrop.jester.api.DatabaseService;
import io.github.snowdrop.jester.api.MongoDbContainer;
import io.github.snowdrop.jester.api.Service;
import io.github.snowdrop.jester.core.JesterContext;
import io.github.snowdrop.jester.core.ManagedResource;
import io.github.snowdrop.jester.resources.containers.ContainerAnnotationBinding;
import java.lang.annotation.Annotation;

public class MongoDbContainerAnnotationBinding
extends ContainerAnnotationBinding {
    private static final String URL_PATTERN = "${JDBC_NAME}://${HOST}:${PORT}";

    public boolean isFor(Annotation ... annotations) {
        return this.findAnnotation(annotations, MongoDbContainer.class).isPresent();
    }

    public ManagedResource getManagedResource(JesterContext context, Service service, Annotation ... annotations) {
        MongoDbContainer metadata = (MongoDbContainer)this.findAnnotation(annotations, MongoDbContainer.class).get();
        if (!(service instanceof DatabaseService)) {
            throw new IllegalStateException("@MongoDbContainer can only be used with DatabaseService service");
        }
        DatabaseService databaseService = (DatabaseService)service;
        databaseService.withJdbcName(metadata.jdbcName());
        databaseService.withJdbcUrlPattern(URL_PATTERN);
        databaseService.withReactiveUrlPattern(URL_PATTERN);
        return this.doInit(context, metadata.image(), metadata.expectedLog(), metadata.command(), metadata.ports());
    }
}

