/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.resources.containers.database;

import io.github.snowdrop.jester.api.DatabaseService;
import io.github.snowdrop.jester.api.MariaDbContainer;
import io.github.snowdrop.jester.api.Service;
import io.github.snowdrop.jester.core.JesterContext;
import io.github.snowdrop.jester.core.ManagedResource;
import io.github.snowdrop.jester.resources.containers.ContainerAnnotationBinding;
import java.lang.annotation.Annotation;

public class MariaDbContainerAnnotationBinding
extends ContainerAnnotationBinding {
    public boolean isFor(Annotation ... annotations) {
        return this.findAnnotation(annotations, MariaDbContainer.class).isPresent();
    }

    public ManagedResource getManagedResource(JesterContext context, Service service, Annotation ... annotations) {
        MariaDbContainer metadata = (MariaDbContainer)this.findAnnotation(annotations, MariaDbContainer.class).get();
        if (!(service instanceof DatabaseService)) {
            throw new IllegalStateException("@MariaDbContainer can only be used with DatabaseService service");
        }
        DatabaseService databaseService = (DatabaseService)service;
        databaseService.withJdbcName(metadata.jdbcName());
        databaseService.withDatabaseNameProperty(metadata.databaseNameProperty());
        databaseService.withUserProperty(metadata.userProperty());
        databaseService.withPasswordProperty(metadata.passwordProperty());
        databaseService.withProperty("ALLOW_EMPTY_PASSWORD", "yes");
        return this.doInit(context, metadata.image(), metadata.expectedLog(), metadata.command(), metadata.ports());
    }
}

