/*
 * Decompiled with CFR 0.152.
 */
package io.github.snowdrop.jester.api;

import io.github.snowdrop.jester.api.HookAction;
import io.github.snowdrop.jester.core.BaseService;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DatabaseService
extends BaseService<DatabaseService> {
    private static final String USER_DEFAULT_VALUE = "user";
    private static final String PASSWORD_DEFAULT_VALUE = "user";
    private static final String DATABASE_DEFAULT_VALUE = "mydb";
    private static final String JDBC_NAME = Pattern.quote("${JDBC_NAME}");
    private static final String HOST = Pattern.quote("${HOST}");
    private static final String PORT = Pattern.quote("${PORT}");
    private static final String DATABASE = Pattern.quote("${DATABASE}");
    private static final String JDBC_URL_PATTERN = "jdbc:${JDBC_NAME}://${HOST}:${PORT}/${DATABASE}";
    private static final String REACTIVE_URL_PATTERN = "${JDBC_NAME}://${HOST}:${PORT}/${DATABASE}";
    private String user = "user";
    private String password = "user";
    private String database = "mydb";
    private String jdbcUrlPattern = "jdbc:${JDBC_NAME}://${HOST}:${PORT}/${DATABASE}";
    private String reactiveUrlPattern = "${JDBC_NAME}://${HOST}:${PORT}/${DATABASE}";
    private String jdbcName;
    private String databaseNameProperty;
    private String userProperty;
    private String passwordProperty;

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getJdbcUrl() {
        return this.jdbcUrlPattern.replaceAll(JDBC_NAME, this.jdbcName).replaceAll(HOST, this.getHost()).replaceAll(PORT, "" + this.getFirstMappedPort()).replaceAll(DATABASE, this.getDatabase());
    }

    public String getReactiveUrl() {
        return this.reactiveUrlPattern.replaceAll(JDBC_NAME, this.jdbcName).replaceAll(HOST, this.getHost()).replaceAll(PORT, "" + this.getFirstMappedPort()).replaceAll(DATABASE, this.getDatabase());
    }

    public DatabaseService overrideDefaults(String user, String password, String database) {
        this.user = user;
        this.password = password;
        this.database = database;
        return this;
    }

    public DatabaseService with(String user, String password, String database) {
        this.withUser(user);
        this.withPassword(password);
        this.withDatabase(database);
        return this;
    }

    public DatabaseService withUser(String user) {
        if (StringUtils.isEmpty((CharSequence)this.userProperty)) {
            throw new UnsupportedOperationException("You cannot configure the user in the current database because the user property has not been provided");
        }
        this.user = user;
        return this;
    }

    public DatabaseService withPassword(String password) {
        if (StringUtils.isEmpty((CharSequence)this.passwordProperty)) {
            throw new UnsupportedOperationException("You cannot configure the password in the current database because the password property has not been provided");
        }
        this.password = password;
        return this;
    }

    public DatabaseService withDatabase(String database) {
        if (StringUtils.isEmpty((CharSequence)this.databaseNameProperty)) {
            throw new UnsupportedOperationException("You cannot configure the database name in the current database because the database name property has not been provided");
        }
        this.database = database;
        return this;
    }

    public DatabaseService withJdbcName(String jdbcName) {
        this.jdbcName = jdbcName;
        return this;
    }

    public DatabaseService withDatabaseNameProperty(String databaseNameProperty) {
        this.databaseNameProperty = databaseNameProperty;
        return this;
    }

    public DatabaseService withUserProperty(String userProperty) {
        this.userProperty = userProperty;
        return this;
    }

    public DatabaseService withPasswordProperty(String passwordProperty) {
        this.passwordProperty = passwordProperty;
        return this;
    }

    public DatabaseService withJdbcUrlPattern(String jdbcUrlPattern) {
        this.jdbcUrlPattern = jdbcUrlPattern;
        return this;
    }

    public DatabaseService withReactiveUrlPattern(String reactiveUrlPattern) {
        this.reactiveUrlPattern = reactiveUrlPattern;
        return this;
    }

    public DatabaseService onPreStart(HookAction action) {
        if (StringUtils.isNotEmpty((CharSequence)this.userProperty)) {
            this.withProperty(this.userProperty, this.getUser());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.passwordProperty)) {
            this.withProperty(this.passwordProperty, this.getPassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.databaseNameProperty)) {
            this.withProperty(this.databaseNameProperty, this.getDatabase());
        }
        return (DatabaseService)super.onPreStart(action);
    }
}

