/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.cache.internal;

import io.github.resilience4j.cache.Cache;
import io.github.resilience4j.cache.event.CacheEvent;
import io.github.resilience4j.cache.event.CacheOnErrorEvent;
import io.github.resilience4j.cache.event.CacheOnHitEvent;
import io.github.resilience4j.cache.event.CacheOnMissEvent;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.EventProcessor;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheImpl<K, V>
implements Cache<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(CacheImpl.class);
    private final javax.cache.Cache<K, V> cache;
    private final CacheMetrics metrics;
    private final CacheEventProcessor eventProcessor;

    public CacheImpl(javax.cache.Cache<K, V> cache) {
        this.cache = cache;
        this.metrics = new CacheMetrics();
        this.eventProcessor = new CacheEventProcessor();
    }

    @Override
    public String getName() {
        return this.cache.getName();
    }

    @Override
    public Cache.Metrics getMetrics() {
        return this.metrics;
    }

    @Override
    public V computeIfAbsent(K cacheKey, CheckedFunction0<V> supplier) {
        return (V)this.getValueFromCache(cacheKey).getOrElse(() -> this.computeAndPut(cacheKey, supplier));
    }

    private V computeAndPut(K cacheKey, CheckedFunction0<V> supplier) {
        return (V)Try.of(supplier).andThen(value -> this.putValueIntoCache(cacheKey, value)).get();
    }

    private Option<V> getValueFromCache(K cacheKey) {
        try {
            Option result = Option.of((Object)this.cache.get(cacheKey));
            if (result.isDefined()) {
                this.onCacheHit(cacheKey);
                return result;
            }
            this.onCacheMiss(cacheKey);
            return result;
        }
        catch (Exception exception) {
            LOG.warn("Failed to get a value from Cache {}", (Object)this.getName(), (Object)exception);
            this.onError(exception);
            return Option.none();
        }
    }

    private void putValueIntoCache(K cacheKey, V value) {
        try {
            if (value != null) {
                this.cache.put(cacheKey, value);
            }
        }
        catch (Exception exception) {
            LOG.warn("Failed to put a value into Cache {}", (Object)this.getName(), (Object)exception);
            this.onError(exception);
        }
    }

    private void onError(Throwable throwable) {
        this.publishCacheEvent(() -> new CacheOnErrorEvent(this.cache.getName(), throwable));
    }

    private void onCacheMiss(K cacheKey) {
        this.metrics.onCacheMiss();
        this.publishCacheEvent(() -> new CacheOnMissEvent<Object>(this.cache.getName(), cacheKey));
    }

    private void onCacheHit(K cacheKey) {
        this.metrics.onCacheHit();
        this.publishCacheEvent(() -> new CacheOnHitEvent<Object>(this.cache.getName(), cacheKey));
    }

    private void publishCacheEvent(Supplier<CacheEvent> event) {
        if (this.eventProcessor.hasConsumers()) {
            this.eventProcessor.processEvent(event.get());
        }
    }

    @Override
    public Cache.EventPublisher getEventPublisher() {
        return this.eventProcessor;
    }

    private final class CacheMetrics
    implements Cache.Metrics {
        private final LongAdder cacheMisses = new LongAdder();
        private final LongAdder cacheHits = new LongAdder();

        private CacheMetrics() {
        }

        void onCacheMiss() {
            this.cacheMisses.increment();
        }

        void onCacheHit() {
            this.cacheHits.increment();
        }

        @Override
        public long getNumberOfCacheHits() {
            return this.cacheHits.longValue();
        }

        @Override
        public long getNumberOfCacheMisses() {
            return this.cacheMisses.longValue();
        }
    }

    private class CacheEventProcessor
    extends EventProcessor<CacheEvent>
    implements EventConsumer<CacheEvent>,
    Cache.EventPublisher {
        private CacheEventProcessor() {
        }

        @Override
        public Cache.EventPublisher onCacheHit(EventConsumer<CacheOnHitEvent> eventConsumer) {
            this.registerConsumer(CacheOnHitEvent.class.getSimpleName(), eventConsumer);
            return this;
        }

        @Override
        public Cache.EventPublisher onCacheMiss(EventConsumer<CacheOnMissEvent> eventConsumer) {
            this.registerConsumer(CacheOnMissEvent.class.getSimpleName(), eventConsumer);
            return this;
        }

        @Override
        public Cache.EventPublisher onError(EventConsumer<CacheOnErrorEvent> eventConsumer) {
            this.registerConsumer(CacheOnErrorEvent.class.getSimpleName(), eventConsumer);
            return this;
        }

        public void consumeEvent(CacheEvent event) {
            super.processEvent((Object)event);
        }
    }
}

