/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteOptions;
import courgette.api.CourgetteRunLevel;
import courgette.api.CucumberOptions;
import courgette.api.HtmlReport;
import courgette.integration.reportportal.ReportPortalProperties;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteSlackOptions;
import courgette.runtime.event.CourgetteEvent;
import courgette.runtime.utils.FileUtils;
import courgette.runtime.utils.SystemPropertyUtils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CourgetteRunOptions
implements CourgetteOptions {
    private CourgetteOptions courgetteOptions;

    public CourgetteRunOptions(Class clazz) {
        this.validate(clazz);
        this.validatePlugins();
        this.validateSlackOptions();
    }

    @Override
    public int threads() {
        return SystemPropertyUtils.getIntProperty("courgette.threads", this.courgetteOptions.threads());
    }

    @Override
    public CourgetteRunLevel runLevel() {
        return SystemPropertyUtils.getEnumProperty("courgette.runLevel", CourgetteRunLevel.class, this.courgetteOptions.runLevel());
    }

    @Override
    public boolean rerunFailedScenarios() {
        return SystemPropertyUtils.getBoolProperty("courgette.rerunFailedScenarios", this.courgetteOptions.rerunFailedScenarios());
    }

    @Override
    public String[] excludeFeatureFromRerun() {
        return SystemPropertyUtils.getStringArrayProperty("courgette.excludeFeatureFromRerun", this.courgetteOptions.excludeFeatureFromRerun());
    }

    @Override
    public int rerunAttempts() {
        return SystemPropertyUtils.getIntProperty("courgette.rerunAttempts", this.courgetteOptions.rerunAttempts());
    }

    @Override
    public boolean showTestOutput() {
        return SystemPropertyUtils.getBoolProperty("courgette.showTestOutput", this.courgetteOptions.showTestOutput());
    }

    @Override
    public String reportTitle() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.reportTitle", this.courgetteOptions.reportTitle(), "Courgette-JVM Report");
    }

    @Override
    public String reportTargetDir() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.reportTargetDir", this.courgetteOptions.reportTargetDir(), "target");
    }

    @Override
    public CucumberOptions cucumberOptions() {
        return this.courgetteOptions.cucumberOptions();
    }

    @Override
    public String[] plugin() {
        return SystemPropertyUtils.getStringArrayProperty("courgette.plugin", this.courgetteOptions.plugin());
    }

    @Override
    public String environmentInfo() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.environmentInfo", this.courgetteOptions.environmentInfo(), "");
    }

    @Override
    public HtmlReport[] disableHtmlReport() {
        return this.courgetteOptions.disableHtmlReport();
    }

    @Override
    public boolean persistParallelCucumberJsonReports() {
        return SystemPropertyUtils.getBoolProperty("courgette.persistParallelCucumberJsonReports", this.courgetteOptions.persistParallelCucumberJsonReports());
    }

    @Override
    public String[] classPath() {
        return SystemPropertyUtils.getStringArrayProperty("courgette.classPath", this.courgetteOptions.classPath());
    }

    @Override
    public String slackWebhookUrl() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.slackWebhookUrl", this.courgetteOptions.slackWebhookUrl(), "");
    }

    @Override
    public String[] slackChannel() {
        return SystemPropertyUtils.getStringArrayProperty("courgette.slackChannel", this.courgetteOptions.slackChannel());
    }

    @Override
    public String slackTestId() {
        return SystemPropertyUtils.getNonEmptyStringProperty("courgette.slackTestId", this.courgetteOptions.slackTestId(), "");
    }

    @Override
    public CourgetteEvent[] slackEventSubscription() {
        return this.courgetteOptions.slackEventSubscription();
    }

    @Override
    public String[] mobileDevice() {
        return SystemPropertyUtils.getStringArrayProperty("courgette.mobileDevice", this.courgetteOptions.mobileDevice());
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return null;
    }

    private void validate(Class clazz) {
        this.courgetteOptions = (CourgetteOptions)Arrays.stream(clazz.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().equals(CourgetteOptions.class)).findFirst().orElseThrow(() -> new CourgetteException("Runner class is not annotated with @CourgetteOptions"));
    }

    private void validatePlugins() {
        if (this.plugin().length > 0) {
            this.validateReportPortalPlugin();
            this.validateMobileDeviceAllocatorPlugin();
        }
    }

    private void validateReportPortalPlugin() {
        String reportPortalPropertiesFilename = "reportportal.properties";
        if (Arrays.stream(this.plugin()).anyMatch(plugin -> plugin.equalsIgnoreCase("reportportal"))) {
            File reportPortalPropertiesFile = FileUtils.getClassPathFile("reportportal.properties");
            if (reportPortalPropertiesFile == null) {
                throw new CourgetteException("The reportportal.properties file must be in your classpath to use the Courgette reportportal plugin");
            }
            ReportPortalProperties.getInstance().validate();
        }
    }

    private void validateMobileDeviceAllocatorPlugin() {
        String[] mobileDevice;
        if (Arrays.stream(this.plugin()).anyMatch(plugin -> plugin.equalsIgnoreCase("mobile-device-allocator")) && ((mobileDevice = this.mobileDevice()).length == 0 || Arrays.stream(mobileDevice).map(device -> device.replace(":", "")).map(String::trim).collect(Collectors.toSet()).stream().allMatch(device -> device.equals("")))) {
            throw new CourgetteException("Mobile device is required when using the Courgette Mobile Device Allocator plugin");
        }
    }

    private void validateSlackOptions() {
        CourgetteSlackOptions slackOptions = new CourgetteSlackOptions(this.slackWebhookUrl(), Arrays.asList(this.slackChannel()), this.slackTestId(), Arrays.asList(this.slackEventSubscription()));
        if (slackOptions.shouldValidate() && !slackOptions.isValid()) {
            throw new CourgetteException("You must provide a Slack webhook URL and valid Slack channels");
        }
    }
}

