/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import io.cucumber.core.filter.Filters;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.gherkin.Location;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CourgettePickleMatcher {
    private final Feature feature;
    private final Filters filters;

    CourgettePickleMatcher(Feature feature, Filters filters) {
        this.feature = feature;
        this.filters = filters;
    }

    public boolean matches() {
        AtomicBoolean matched = new AtomicBoolean();
        try {
            this.feature.getPickles().forEach(pickle -> {
                matched.set(this.filters.test(pickle));
                if (matched.get()) {
                    throw new ConditionSatisfiedException();
                }
            });
        }
        catch (ConditionSatisfiedException conditionSatisfiedException) {
            // empty catch block
        }
        return matched.get();
    }

    public Location matchLocation(int pickleLocationLine) {
        Location[] location = new Location[]{null};
        List pickles = this.feature.getPickles();
        try {
            pickles.stream().filter(p -> p.getLocation().getLine() == pickleLocationLine).findFirst().ifPresent(pickleEvent -> {
                if (this.filters.test(pickleEvent)) {
                    location[0] = new Location(pickleEvent.getLocation().getLine(), pickleEvent.getLocation().getColumn());
                    throw new ConditionSatisfiedException();
                }
            });
        }
        catch (ConditionSatisfiedException conditionSatisfiedException) {
            // empty catch block
        }
        return location[0];
    }

    private class ConditionSatisfiedException
    extends RuntimeException {
        private ConditionSatisfiedException() {
        }
    }
}

