/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.messages.NdjsonToMessageIterable;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TestCase;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CourgetteNdJsonCreator {
    private final Map<Feature, List<List<Envelope>>> messages;
    private final Predicate<Envelope> gherkinEnvelope = envelope -> envelope.getGherkinDocument() != null;
    private final Predicate<Envelope> metaEnvelope = envelope -> envelope.getMeta() != null;
    private final Predicate<Envelope> testRunStartedOrFinishedEnvelope = envelope -> envelope.getTestRunStarted() != null || envelope.getTestRunFinished() != null;
    private final Predicate<TestCase> testCase = testCase -> !testCase.getPickleId().equals("");

    public CourgetteNdJsonCreator(Map<Feature, List<List<Envelope>>> messages) {
        this.messages = messages;
    }

    public static List<Envelope> createMessages(String source) {
        List<String> messageList = Arrays.asList(source.split("\n"));
        ArrayList<Envelope> messages = new ArrayList<Envelope>(messageList.size());
        messageList.forEach(m -> {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(m.getBytes(StandardCharsets.UTF_8));
                for (Envelope message : new NdjsonToMessageIterable((InputStream)in)) {
                    messages.add(message);
                }
            }
            catch (Exception e) {
                CourgetteException.printExceptionStackTrace(e);
            }
        });
        return messages;
    }

    public List<Envelope> createFeatureMessages() {
        return this.getMessages();
    }

    public List<Envelope> createScenarioMessages() {
        return this.getScenarioMessages();
    }

    private List<Envelope> getMessages() {
        List<Envelope> featureMessages = this.messages.values().stream().flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        return this.mutateMessages(featureMessages);
    }

    private List<Envelope> getScenarioMessages() {
        ArrayList<Envelope> scenarioMessages = new ArrayList<Envelope>();
        this.messages.forEach((k, v) -> {
            ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
            ArrayList<Envelope> messages = new ArrayList<Envelope>();
            v.forEach(message -> this.addMessage((List<Envelope>)message, (List<Scenario>)scenarios, (List<Envelope>)messages));
            Envelope oldGherkinDocument = this.extractFirstGherkinDocument(messages);
            Envelope newGherkinDocument = this.createNewGherkinDocument(oldGherkinDocument, scenarios);
            messages.removeIf(this.gherkinEnvelope);
            messages.add(3, newGherkinDocument);
            scenarioMessages.addAll(messages);
        });
        return this.mutateMessages(scenarioMessages);
    }

    private List<Envelope> mutateMessages(List<Envelope> envelopes) {
        if (envelopes != null && !envelopes.isEmpty()) {
            Envelope testRunStarted = this.createTestRunStarted(envelopes);
            Envelope testRunFinished = this.createTestRunFinished(envelopes);
            envelopes.subList(1, envelopes.size()).removeIf(this.metaEnvelope);
            envelopes.removeIf(this.testRunStartedOrFinishedEnvelope);
            envelopes.add(2, testRunStarted);
            envelopes.add(testRunFinished);
            return envelopes;
        }
        return null;
    }

    private void addMessage(List<Envelope> envelopes, List<Scenario> scenarios, List<Envelope> messages) {
        ArrayList envelopeList = new ArrayList();
        Optional<TestCase> testCase = this.extractTestCase(envelopes);
        Optional<Pickle> pickle = this.extractPickle(envelopes, testCase);
        envelopes.forEach(envelope -> {
            if (pickle.isPresent()) {
                if (envelope.getGherkinDocument() != null) {
                    Optional<Scenario> scenario = envelope.getGherkinDocument().getFeature().getChildren().stream().map(FeatureChild::getScenario).filter(Objects::nonNull).filter(t -> t.getId().equals(((Pickle)pickle.get()).getAstNodeIds().get(0))).findFirst();
                    scenario.ifPresent(scenarios::add);
                    envelopeList.add(envelope);
                } else if (envelope.getPickle() != null) {
                    if (envelope.getPickle() == pickle.get()) {
                        envelopeList.add(envelope);
                    }
                } else {
                    envelopeList.add(envelope);
                }
            }
        });
        messages.addAll(envelopeList);
    }

    private Envelope extractFirstGherkinDocument(List<Envelope> envelopes) {
        return envelopes.stream().filter(this.gherkinEnvelope).findFirst().get();
    }

    private Envelope createNewGherkinDocument(Envelope gherkinDocument, List<Scenario> scenarios) {
        ArrayList children = new ArrayList();
        scenarios.forEach(scenario -> {
            FeatureChild featureChild = new FeatureChild();
            featureChild.setScenario(scenario);
            children.add(featureChild);
        });
        io.cucumber.messages.types.Feature feature = gherkinDocument.getGherkinDocument().getFeature();
        feature.setChildren(children);
        gherkinDocument.getGherkinDocument().setFeature(feature);
        return gherkinDocument;
    }

    private Optional<TestCase> extractTestCase(List<Envelope> envelopes) {
        return envelopes.stream().map(Envelope::getTestCase).filter(Objects::nonNull).filter(this.testCase).findFirst();
    }

    private Optional<Pickle> extractPickle(List<Envelope> envelopes, Optional<TestCase> testCase) {
        if (!envelopes.isEmpty() && testCase.isPresent()) {
            return envelopes.stream().map(Envelope::getPickle).filter(Objects::nonNull).filter(pickle -> pickle.getId().equals(((TestCase)testCase.get()).getPickleId())).findFirst();
        }
        return Optional.empty();
    }

    private Envelope createTestRunStarted(List<Envelope> envelopes) {
        long seconds = envelopes.stream().map(Envelope::getTestRunStarted).filter(Objects::nonNull).map(TestRunStarted::getTimestamp).min(Comparator.comparingLong(Timestamp::getSeconds)).get().getSeconds();
        Timestamp timestamp = new Timestamp();
        timestamp.setSeconds(Long.valueOf(seconds));
        TestRunStarted testRunStarted = new TestRunStarted();
        testRunStarted.setTimestamp(timestamp);
        Envelope testRunStartedEnvelope = new Envelope();
        testRunStartedEnvelope.setTestRunStarted(testRunStarted);
        return testRunStartedEnvelope;
    }

    private Envelope createTestRunFinished(List<Envelope> envelopes) {
        long seconds = envelopes.stream().map(Envelope::getTestRunFinished).filter(Objects::nonNull).map(TestRunFinished::getTimestamp).max(Comparator.comparingLong(Timestamp::getSeconds)).get().getSeconds();
        Timestamp timestamp = new Timestamp();
        timestamp.setSeconds(Long.valueOf(seconds));
        TestRunFinished testRunFinished = new TestRunFinished();
        testRunFinished.setTimestamp(timestamp);
        Envelope testRunFinishedEnvelope = new Envelope();
        testRunFinishedEnvelope.setTestRunFinished(testRunFinished);
        return testRunFinishedEnvelope;
    }
}

