/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteMobileDevice;
import courgette.runtime.CourgettePluginService;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.utils.FileUtils;
import courgette.runtime.utils.SystemPropertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class CourgetteFeatureRunner {
    private final Map<String, List<String>> runnerArgs;
    private final CourgetteProperties courgetteProperties;
    private final CourgettePluginService courgettePluginService;

    CourgetteFeatureRunner(Map<String, List<String>> runnerArgs, CourgetteProperties courgetteProperties, CourgettePluginService courgettePluginService) {
        this.runnerArgs = runnerArgs;
        this.courgetteProperties = courgetteProperties;
        this.courgettePluginService = courgettePluginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run() {
        Process process = null;
        Builder thisBuilder = new Builder();
        try {
            ProcessBuilder builder = thisBuilder.buildProcess();
            process = builder.start();
            process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            CourgetteException.printExceptionStackTrace(e);
        }
        finally {
            if (thisBuilder.getDevice().isPresent()) {
                this.courgettePluginService.getCourgetteMobileDeviceAllocatorService().deallocateDevice(thisBuilder.getDevice().get());
            }
        }
        return process != null ? process.exitValue() : -1;
    }

    class Builder {
        private static final String CUCUMBER_PROPERTY = "-Dcucumber";
        private static final String CUCUMBER_PROPERTY_PUBLISH_DISABLED = "-Dcucumber.publish.enabled=false";
        private static final String CUCUMBER_PROPERTY_PUBLISH_QUITE = "-Dcucumber.publish.quiet=true";
        private static final String CUCUMBER_PUBLISH_TOKEN = "CUCUMBER_PUBLISH_TOKEN";
        private CourgetteMobileDevice device;

        Builder() {
        }

        ProcessBuilder buildProcess() {
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            this.environmentVariablesToRemove().forEach(builder.environment()::remove);
            if (CourgetteFeatureRunner.this.courgetteProperties.getCourgetteOptions().showTestOutput()) {
                builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            } else {
                File tempFile = FileUtils.getTempFile();
                if (tempFile != null) {
                    builder.redirectOutput(tempFile);
                }
            }
            builder.redirectErrorStream(true);
            ArrayList<String> commands = new ArrayList<String>();
            commands.add("java");
            SystemPropertyUtils.splitAndAddPropertyToList("courgette.vmoptions", commands);
            commands.addAll(this.getSystemProperties());
            this.checkCustomClassPath(commands);
            commands.add("io.cucumber.core.cli.Main");
            CourgetteFeatureRunner.this.runnerArgs.forEach((key, value) -> commands.addAll((Collection<String>)value));
            builder.command(commands);
            return builder;
        }

        public Optional<CourgetteMobileDevice> getDevice() {
            return Optional.ofNullable(this.device);
        }

        private List<String> getSystemProperties() {
            ArrayList<String> systemPropertyList = new ArrayList<String>();
            System.getProperties().keySet().forEach(property -> systemPropertyList.add(String.format("-D%s=%s", property, System.getProperty(property.toString()))));
            systemPropertyList.removeIf(this.cucumberSystemPropertiesRequiresRemoval());
            this.addCucumberSystemProperties(systemPropertyList);
            this.addCourgetteMobileDeviceAllocatorProperties(systemPropertyList);
            return systemPropertyList;
        }

        private void addCucumberSystemProperties(List<String> systemPropertyList) {
            systemPropertyList.add(CUCUMBER_PROPERTY_PUBLISH_DISABLED);
            systemPropertyList.add(CUCUMBER_PROPERTY_PUBLISH_QUITE);
        }

        private void addCourgetteMobileDeviceAllocatorProperties(List<String> systemPropertyList) {
            if (CourgetteFeatureRunner.this.courgetteProperties.isMobileDeviceAllocationPluginEnabled()) {
                this.device = CourgetteFeatureRunner.this.courgettePluginService.getCourgetteMobileDeviceAllocatorService().allocateDevice();
                systemPropertyList.add(String.format("-D%s=%s", "courgette.mobile.device.name", this.device.getDeviceName()));
                systemPropertyList.add(String.format("-D%s=%s", "courgette.mobile.device.parallel.port", this.device.getParallelPort()));
                if (this.device.getUdid() != null) {
                    systemPropertyList.add(String.format("-D%s=%s", "courgette.mobile.device.udid", this.device.getUdid()));
                }
            }
        }

        private Predicate<String> cucumberSystemPropertiesRequiresRemoval() {
            return s -> s.startsWith(CUCUMBER_PROPERTY) || s.contains(CUCUMBER_PUBLISH_TOKEN);
        }

        private List<String> environmentVariablesToRemove() {
            ArrayList<String> environment = new ArrayList<String>();
            environment.add(CUCUMBER_PUBLISH_TOKEN);
            return environment;
        }

        private void checkCustomClassPath(List<String> commands) {
            if (CourgetteFeatureRunner.this.courgetteProperties.useCustomClasspath()) {
                commands.removeIf(c -> c.startsWith("-Djava.class.path"));
                commands.add("-cp");
                commands.add(String.join((CharSequence)File.pathSeparator, CourgetteFeatureRunner.this.courgetteProperties.getCourgetteOptions().classPath()));
            }
        }
    }
}

