/*
 * Decompiled with CFR 0.152.
 */
package courgette.runtime;

import courgette.api.CourgetteAfterAll;
import courgette.api.CourgetteBeforeAll;
import courgette.runtime.CourgetteException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class CourgetteCallbacks {
    private final Class<?> clazz;

    public CourgetteCallbacks(Class<?> clazz) {
        this.clazz = clazz;
    }

    public void beforeAll() {
        this.getCallbacksForAnnotation(CourgetteBeforeAll.class).stream().sorted(Comparator.comparingInt(method -> method.getAnnotation(CourgetteBeforeAll.class).order())).forEachOrdered(method -> this.invokeCallback((Method)method, new Object[0]));
    }

    public void afterAll() {
        this.getCallbacksForAnnotation(CourgetteAfterAll.class).stream().sorted(Comparator.comparingInt(method -> method.getAnnotation(CourgetteAfterAll.class).order())).forEachOrdered(method -> this.invokeCallback((Method)method, new Object[0]));
    }

    private List<Method> getCallbacksForAnnotation(Class<? extends Annotation> annotation) {
        return Arrays.stream(this.clazz.getMethods()).filter(method -> Modifier.isStatic(method.getModifiers()) && method.isAnnotationPresent(annotation) && method.getParameterCount() == 0).collect(Collectors.toList());
    }

    private void invokeCallback(Method callback, Object ... args) {
        try {
            callback.invoke(null, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new CourgetteException(e);
        }
    }
}

