/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.slack;

import courgette.runtime.CourgetteException;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class SlackService {
    private final String webhookUrl;

    public SlackService(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public synchronized void postMessage(String message) {
        HttpClient client = this.createHttpClient();
        HttpEntity entity = EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(message).build();
        HttpPost post = new HttpPost(this.webhookUrl);
        post.setEntity(entity);
        try {
            HttpResponse result = client.execute((HttpUriRequest)post);
            if (result != null && result.getStatusLine().getStatusCode() != 200) {
                String body = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                CourgetteException.printError("Courgette Slack Service: error sending message to Slack channel -> " + body);
            }
        }
        catch (IOException e) {
            CourgetteException.printError("Courgette Slack Service: " + e.getMessage());
        }
    }

    private HttpClient createHttpClient() {
        try {
            SSLContext trustedSSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            return HttpClientBuilder.create().setSSLContext(trustedSSLContext).build();
        }
        catch (Exception e) {
            CourgetteException.printError("Courgette Slack Service: error creating a secure http client -> " + e.getMessage());
            return HttpClientBuilder.create().build();
        }
    }
}

