/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.slack;

import courgette.integration.slack.SlackMessageSender;
import courgette.integration.slack.SlackService;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgettePublisher;
import courgette.runtime.CourgetteSlackOptions;
import courgette.runtime.event.CourgetteEventHolder;
import courgette.runtime.event.EventPublisher;
import courgette.runtime.event.EventSubscriberCreator;
import java.util.Arrays;
import java.util.Optional;

public class SlackPublisher
implements CourgettePublisher {
    private Optional<EventPublisher> eventPublisher = Optional.empty();

    public SlackPublisher(CourgetteProperties courgetteProperties) {
        if (courgetteProperties.publishEventsToSlack()) {
            CourgetteSlackOptions slackOptions = courgetteProperties.slackOptions();
            SlackService slackService = new SlackService(slackOptions.getWebhookUrl());
            this.eventPublisher = Optional.of(new EventPublisher(new SlackMessageSender(slackService, slackOptions)));
            EventSubscriberCreator.createEventSubscribers(this.eventPublisher.get(), Arrays.asList(courgetteProperties.getCourgetteOptions().slackEventSubscription()));
        }
    }

    @Override
    public void publish(CourgetteEventHolder eventHolder) {
        this.eventPublisher.ifPresent(p -> p.publishEvent(eventHolder));
    }
}

