/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal.request;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import courgette.integration.reportportal.ReportPortalProperties;
import java.time.Instant;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class LaunchRequest {
    public HttpEntity create(ReportPortalProperties reportPortalProperties) {
        JsonObject body = new JsonObject();
        body.addProperty("name", reportPortalProperties.getLaunchName());
        body.addProperty("startTime", Instant.now().toString());
        body.addProperty("mode", "DEFAULT");
        LaunchRequest.addAttributes(body, reportPortalProperties.getAttributes());
        return new StringEntity(body.toString(), ContentType.APPLICATION_JSON);
    }

    private static void addAttributes(JsonObject body, String attributes) {
        String[] attributeKeyValue;
        if (attributes != null && !attributes.trim().isEmpty() && (attributeKeyValue = attributes.split(";")).length > 0) {
            JsonArray attributeArray = new JsonArray();
            for (String attributePair : attributeKeyValue) {
                JsonObject attributeObj = new JsonObject();
                Collections.singletonList(attributePair).forEach(attr -> {
                    String[] attrKeyValue = attr.split(":");
                    if (attrKeyValue.length > 0) {
                        switch (attrKeyValue.length) {
                            case 1: {
                                attributeObj.addProperty("value", attrKeyValue[0]);
                                break;
                            }
                            case 2: {
                                attributeObj.addProperty("key", attrKeyValue[0]);
                                attributeObj.addProperty("value", attrKeyValue[1]);
                            }
                        }
                        attributeArray.add((JsonElement)attributeObj);
                    }
                });
            }
            body.add("attributes", (JsonElement)attributeArray);
        }
    }
}

