/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import courgette.integration.reportportal.ReportPortalProperties;
import courgette.integration.reportportal.request.FinishRequest;
import courgette.integration.reportportal.request.LaunchRequest;
import courgette.integration.reportportal.request.ScenarioLogRequest;
import courgette.integration.reportportal.request.ScenarioRequest;
import courgette.integration.reportportal.request.TestRequest;
import courgette.integration.reportportal.request.TestSuiteRequest;
import courgette.runtime.CourgetteException;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgetteRunnerInfo;
import courgette.runtime.report.JsonReportParser;
import courgette.runtime.report.model.Feature;
import courgette.runtime.report.model.Scenario;
import courgette.runtime.report.model.Tag;
import courgette.runtime.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class ReportPortalService {
    private final ReportPortalProperties reportPortalProperties;
    private final CourgetteProperties courgetteProperties;
    private final HttpClient httpClient;
    private final List<io.cucumber.core.gherkin.Feature> features;
    private final ConcurrentHashMap<String, String> testIds = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> testCounters = new ConcurrentHashMap();
    private String launchId;
    private String testSuiteId;
    private final Predicate<Integer> isSuccessfulCall = status -> status == 200 || status == 201;

    public ReportPortalService(ReportPortalProperties reportPortalProperties, CourgetteProperties courgetteProperties, List<io.cucumber.core.gherkin.Feature> features) {
        this.reportPortalProperties = reportPortalProperties;
        this.courgetteProperties = courgetteProperties;
        this.httpClient = this.createHttpClient();
        this.features = features;
    }

    public void startLaunch() {
        this.launchId = this.call((HttpUriRequest)this.post(this.apiEndpoint() + "/launch", new LaunchRequest().create(this.reportPortalProperties)));
    }

    public void startTestSuite() {
        if (this.launchId != null) {
            this.testSuiteId = this.call((HttpUriRequest)this.post(this.apiEndpoint() + "/item", new TestSuiteRequest().create(this.reportPortalProperties.getTestSuite(), this.launchId)));
        }
        if (this.testSuiteId != null) {
            this.createTestIds(this.testIds, this.features);
            this.createTestCounters(this.testCounters, this.features);
        }
    }

    public void addTest(CourgetteRunnerInfo runnerInfo) {
        if (this.testSuiteId != null) {
            String testName = this.createFeatureName(runnerInfo.getFeature());
            String testId = this.testIds.get(testName);
            File reportFile = runnerInfo.getJsonReportFile();
            if (reportFile == null) {
                CourgetteException.printError("Courgette Report Portal Service: unable to add test due to missing report data. Feature URI -> " + runnerInfo.getFeature().getUri());
                this.finishTest(testId);
                return;
            }
            List<Feature> features = JsonReportParser.create(reportFile, this.courgetteProperties.getCourgetteOptions().runLevel()).getReportFeatures();
            List scenarios = features.stream().flatMap(feature -> feature.getScenarios().stream()).collect(Collectors.toList());
            for (Scenario scenario : scenarios) {
                String scenarioId;
                if (testId == null || (scenarioId = this.startScenario(testId, scenario)) == null) continue;
                this.addScenarioLog(scenarioId, scenario);
                this.finishScenario(scenarioId, scenario.passed() ? "passed" : "failed");
                this.testCounters.put(testName, this.testCounters.get(testName) - 1L);
            }
            if (this.testCounters.get(testName) <= 0L) {
                this.finishTest(testId);
            }
        }
    }

    public void finishTestSuite() {
        if (this.testSuiteId != null) {
            this.call((HttpUriRequest)this.put(this.apiEndpoint() + "/item/" + this.testSuiteId, new FinishRequest().create(this.launchId)));
        }
    }

    public void finishLaunch() {
        if (this.launchId != null) {
            this.call((HttpUriRequest)this.put(this.apiEndpoint() + "/launch/" + this.launchId + "/finish", new FinishRequest().create(this.launchId)));
        }
    }

    public void outputLaunchLink() {
        String id;
        if (this.launchId != null && (id = this.call((HttpUriRequest)this.get(this.apiEndpoint() + "/launch/" + this.launchId))) != null) {
            String out = "\n------------------------------------------------------------------------\nCourgette published your results to Report Portal:\n" + String.format("%s/ui/#%s/launches/all/%s", this.rpServerUrl(), this.reportPortalProperties.getProject(), id) + "\n------------------------------------------------------------------------\n";
            System.out.println(out);
        }
    }

    private String startTest(String featureName) {
        return this.call((HttpUriRequest)this.post(this.apiEndpoint() + "/item/" + this.testSuiteId, TestRequest.create(featureName, this.launchId)));
    }

    private void finishTest(String testId) {
        if (testId != null) {
            this.call((HttpUriRequest)this.put(this.apiEndpoint() + "/item/" + testId, new FinishRequest().create(this.launchId)));
        }
    }

    private String startScenario(String testId, Scenario scenario) {
        return this.call((HttpUriRequest)this.post(this.apiEndpoint() + "/item/" + testId, ScenarioRequest.create(scenario.getName(), scenario.getTags().stream().map(Tag::getName).collect(Collectors.toList()), this.launchId)));
    }

    private void addScenarioLog(String scenarioId, Scenario scenario) {
        this.call((HttpUriRequest)this.post(this.apiEndpoint() + "/log", new ScenarioLogRequest().create(scenario, scenarioId, this.launchId)));
    }

    private void finishScenario(String scenarioId, String status) {
        this.call((HttpUriRequest)this.put(this.apiEndpoint() + "/item/" + scenarioId, new FinishRequest().create(status, this.launchId)));
    }

    private String createFeatureName(io.cucumber.core.gherkin.Feature feature) {
        return FileUtils.getFileName(feature.getUri()).split("\\.")[0];
    }

    private void createTestIds(ConcurrentHashMap<String, String> testIds, List<io.cucumber.core.gherkin.Feature> features) {
        features.stream().map(this::createFeatureName).distinct().sorted().forEach(testName -> testIds.put((String)testName, this.startTest((String)testName)));
    }

    private void createTestCounters(ConcurrentHashMap<String, Long> testCounters, List<io.cucumber.core.gherkin.Feature> features) {
        testCounters.putAll(features.stream().map(this::createFeatureName).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }

    private String apiEndpoint() {
        return String.format("%s/api/v1/%s", this.reportPortalProperties.getEndpoint(), this.reportPortalProperties.getProject());
    }

    private HttpPost post(String uri, HttpEntity entity) {
        HttpPost post = new HttpPost(uri);
        post.addHeader(this.authHeader());
        post.setEntity(entity);
        return post;
    }

    private HttpPut put(String uri, HttpEntity entity) {
        HttpPut put = new HttpPut(uri);
        put.addHeader(this.authHeader());
        put.setEntity(entity);
        return put;
    }

    private HttpGet get(String uri) {
        HttpGet get = new HttpGet(uri);
        get.addHeader(this.authHeader());
        return get;
    }

    private Header authHeader() {
        return new BasicHeader("Authorization", "bearer " + this.reportPortalProperties.getApiToken());
    }

    private HttpClient createHttpClient() {
        try {
            SSLContext trustedSSLContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE).build();
            return HttpClientBuilder.create().setSSLContext(trustedSSLContext).build();
        }
        catch (Exception e) {
            CourgetteException.printError("Courgette Report Portal Service: error creating a secure http client: " + e.getMessage());
            return HttpClientBuilder.create().build();
        }
    }

    private synchronized String call(HttpUriRequest request) {
        String id = null;
        try {
            HttpResponse response = this.httpClient.execute(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            if (this.isSuccessfulCall.test(response.getStatusLine().getStatusCode())) {
                JsonElement idElement = JsonParser.parseString((String)responseBody).getAsJsonObject().get("id");
                if (idElement != null) {
                    id = idElement.getAsString();
                }
            } else {
                CourgetteException.printError("Courgette Report Portal Service: " + responseBody);
            }
        }
        catch (IOException e) {
            CourgetteException.printError("Courgette Report Portal Service: " + e.getMessage());
        }
        return id;
    }

    private String rpServerUrl() {
        String server = this.reportPortalProperties.getEndpoint();
        if (server.endsWith("/")) {
            server = server.substring(0, server.lastIndexOf("/"));
        }
        return server;
    }
}

