/*
 * Decompiled with CFR 0.152.
 */
package courgette.integration.reportportal;

import courgette.integration.reportportal.ReportPortalProperties;
import courgette.integration.reportportal.ReportPortalSender;
import courgette.integration.reportportal.ReportPortalService;
import courgette.runtime.CourgetteProperties;
import courgette.runtime.CourgettePublisher;
import courgette.runtime.event.CourgetteEvent;
import courgette.runtime.event.CourgetteEventHolder;
import courgette.runtime.event.EventPublisher;
import courgette.runtime.event.EventSubscriberCreator;
import io.cucumber.core.gherkin.Feature;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ReportPortalPublisher
implements CourgettePublisher {
    private Optional<EventPublisher> eventPublisher = Optional.empty();

    public ReportPortalPublisher(CourgetteProperties courgetteProperties, List<Feature> features) {
        if (courgetteProperties.isReportPortalPluginEnabled()) {
            ReportPortalService reportPortalService = new ReportPortalService(ReportPortalProperties.getInstance(), courgetteProperties, features);
            this.eventPublisher = Optional.of(new EventPublisher(new ReportPortalSender(reportPortalService)));
            EventSubscriberCreator.createEventSubscribers(this.eventPublisher.get(), Arrays.asList(CourgetteEvent.TEST_RUN_STARTED, CourgetteEvent.TEST_RUN_FINISHED, CourgetteEvent.TEST_PASSED, CourgetteEvent.TEST_PASSED_AFTER_RERUN, CourgetteEvent.TEST_FAILED));
        }
    }

    @Override
    public void publish(CourgetteEventHolder eventHolder) {
        this.eventPublisher.ifPresent(p -> p.publishEvent(eventHolder));
    }
}

