/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngoanh2n.jsoupxpath;

import io.github.ngoanh2n.jsoupxpath.NodeHelper;
import io.github.ngoanh2n.jsoupxpath.XpathEvaluators;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;

public class NodeXpath {
    private final LinkedList<Tag> tags;

    public NodeXpath(@Nonnull Node node) {
        this.tags = this.nodeToTags(node);
    }

    public NodeXpath(@Nonnull String xpath) {
        this.tags = this.xpathToTags(xpath);
    }

    public String getLocationPath() {
        StringBuilder path = new StringBuilder();
        if (!this.tags.isEmpty()) {
            path.append("/");
            this.tags.forEach(tag -> path.append("/").append(tag.toString()));
        }
        return path.toString();
    }

    public String toString() {
        return this.getLocationPath();
    }

    List<Evaluator> evaluators() {
        LinkedList<Evaluator> results = new LinkedList<Evaluator>();
        for (int i = 0; i < this.tags.size(); ++i) {
            Tag tag = this.tags.get(i);
            Evaluator evaluator = results.size() == 0 ? XpathEvaluators.root() : (results.size() == 1 ? results.get(0) : XpathEvaluators.combination(results));
            results.clear();
            LinkedList<Evaluator> evaluators = new LinkedList<Evaluator>();
            evaluators.add(XpathEvaluators.tag(tag.name));
            if (!tag.isUnique()) {
                evaluators.add(XpathEvaluators.index(tag.index));
            }
            if (i == 0) {
                evaluators.add(XpathEvaluators.ancestor(evaluator));
            } else {
                evaluators.add(XpathEvaluators.parent(evaluator));
            }
            evaluator = XpathEvaluators.combination(evaluators);
            results.add(evaluator);
        }
        return results;
    }

    private LinkedList<Tag> nodeToTags(Node node) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        if (NodeHelper.standard(node)) {
            Elements parents = ((Element)node).parents();
            for (int i = parents.size() - 1; i >= 0; --i) {
                tags.add(NodeXpath.elementToTag((Element)parents.get(i)));
            }
            tags.add(NodeXpath.elementToTag((Element)node));
        }
        return tags;
    }

    private LinkedList<Tag> xpathToTags(String xpath) {
        if (!xpath.startsWith("/")) {
            xpath = "/" + xpath;
        }
        LinkedList<Tag> tags = new LinkedList<Tag>();
        String inputRegex = "^(|/)(((/[a-z]{1,10})(|\\[\\d]))+)$";
        Matcher inputMatcher = Pattern.compile(inputRegex).matcher(xpath);
        if (inputMatcher.find()) {
            xpath = inputMatcher.group(2);
            String tagRegex = "([a-z]{1,10})(\\[\\d]|)";
            Matcher tagMatcher = Pattern.compile(tagRegex).matcher(xpath);
            while (tagMatcher.find()) {
                String tagName = tagMatcher.group(1);
                String tagIndex = tagMatcher.group(2);
                if (tagIndex.isEmpty()) {
                    tags.add(new Tag(tagName));
                    continue;
                }
                String indexRegex = "^\\[(\\d)]$";
                Matcher indexMatcher = Pattern.compile(indexRegex).matcher(tagIndex);
                if (!indexMatcher.find()) continue;
                tags.add(new Tag(tagName, Integer.parseInt(indexMatcher.group(1))));
            }
        }
        return tags;
    }

    private static Tag elementToTag(Element element) {
        Elements children;
        Elements sibling;
        Tag tag = new Tag(element.nodeName());
        Element parent = element.parent();
        if (parent != null && (sibling = (children = parent.children()).select(element.nodeName())).size() > 0) {
            for (int j = 0; j < sibling.size(); ++j) {
                if (!((Element)sibling.get(j)).equals((Object)element)) continue;
                tag.index = j + 1;
                break;
            }
        }
        return tag;
    }

    private static final class Tag {
        private int index;
        private final String name;

        Tag(String name) {
            this(name, 1);
        }

        Tag(String name, int index) {
            this.name = name;
            this.index = index;
        }

        boolean isUnique() {
            return this.index == 1;
        }

        public String toString() {
            return this.index == 1 ? this.name : this.name + "[" + this.index + "]";
        }
    }
}

