/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.watcher;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.client.PublisherClient;
import org.sonatype.central.publisher.client.model.DeploymentApiResponse;
import org.sonatype.central.publisher.client.model.DeploymentState;
import org.sonatype.central.publisher.plugin.exceptions.DeploymentPublishFailedException;
import org.sonatype.central.publisher.plugin.exceptions.DeploymentPublishTimedOutException;
import org.sonatype.central.publisher.plugin.model.WaitForDeploymentStateRequest;
import org.sonatype.central.publisher.plugin.model.WaitUntilRequest;
import org.sonatype.central.publisher.plugin.utils.PurlUtils;
import org.sonatype.central.publisher.plugin.watcher.DeploymentPublishedWatcher;

@Component(role=DeploymentPublishedWatcher.class)
public class DeploymentPublishedWatcherImpl
extends AbstractLogEnabled
implements DeploymentPublishedWatcher {
    @Requirement
    private PublisherClient publisherClient;
    @Requirement
    private PurlUtils purlUtils;

    public DeploymentPublishedWatcherImpl() {
    }

    DeploymentPublishedWatcherImpl(PublisherClient publisherClient, PurlUtils purlUtils) {
        this.publisherClient = publisherClient;
        this.purlUtils = purlUtils;
    }

    @Override
    public void waitForDeploymentState(WaitForDeploymentStateRequest waitForDeploymentStateRequest) {
        Instant start = Instant.now();
        String deploymentId = waitForDeploymentStateRequest.getDeploymentId();
        WaitUntilRequest waitUntilRequest = waitForDeploymentStateRequest.getWaitUntilRequest();
        DeploymentApiResponse status = null;
        this.getLogger().info(String.format("Waiting until Deployment %s is %s", deploymentId, waitForDeploymentStateRequest.waitTypeName()));
        try {
            while (Duration.between(start, Instant.now()).get(ChronoUnit.SECONDS) < (long)waitForDeploymentStateRequest.getWaitMaxTimeInSeconds()) {
                Integer interval = waitForDeploymentStateRequest.getWaitPollingIntervalInSeconds() * 1000;
                Thread.sleep(interval.longValue());
                this.getLogger().debug("Requesting status for Deployment " + deploymentId);
                status = this.publisherClient.status(deploymentId);
                DeploymentState deploymentState = status.getDeploymentState();
                this.getLogger().debug(String.format("Deployment %s in state: %s", deploymentId, deploymentState.name().toLowerCase()));
                switch (deploymentState) {
                    case PENDING: 
                    case VALIDATING: {
                        if (waitUntilRequest != WaitUntilRequest.UPLOADED) break;
                        this.outputWhereToFinishPublishing(waitForDeploymentStateRequest, deploymentId);
                        return;
                    }
                    case VALIDATED: 
                    case PUBLISHING: {
                        if (waitUntilRequest != WaitUntilRequest.UPLOADED && waitUntilRequest != WaitUntilRequest.VALIDATED) break;
                        this.outputWhereToFinishPublishing(waitForDeploymentStateRequest, deploymentId);
                        return;
                    }
                    case PUBLISHED: {
                        this.outputPublished(status);
                        return;
                    }
                    case FAILED: {
                        this.outputError(status);
                        return;
                    }
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.outputTimeout(deploymentId, status);
    }

    private void outputPublished(DeploymentApiResponse status) {
        StringBuilder successMessage = new StringBuilder();
        successMessage.append("Deployment ").append(status.getDeploymentId()).append(" was successfully published\n").append("Packages\n");
        for (String purl : status.getPurls()) {
            String purlDisplay = this.purlUtils.toRepo1Url(purl).orElse(purl);
            successMessage.append(" - ").append(purlDisplay).append("\n");
        }
        this.getLogger().info(successMessage.toString());
    }

    private void outputError(DeploymentApiResponse status) {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append("\n\n").append("Deployment ").append(status.getDeploymentId()).append(" failed\n");
        for (Map.Entry<String, List<String>> errorCategory : status.getErrors().entrySet()) {
            errorMessage.append(errorCategory.getKey()).append(":\n");
            for (String error : errorCategory.getValue()) {
                errorMessage.append(" - ").append(error).append("\n");
            }
            errorMessage.append("\n");
        }
        this.getLogger().error(errorMessage.toString());
        throw new DeploymentPublishFailedException(status.getDeploymentId(), status.getDeploymentName());
    }

    private void outputTimeout(String deploymentId, DeploymentApiResponse status) {
        if (null != status) {
            this.getLogger().debug(String.format("Deployment %s timed out with the last recorded status of: %s", new Object[]{deploymentId, status.getDeploymentState()}));
        }
        throw new DeploymentPublishTimedOutException(deploymentId);
    }

    private void outputWhereToFinishPublishing(WaitForDeploymentStateRequest waitForDeploymentStateRequest, String deploymentId) {
        this.getLogger().info(String.format("Deployment %s has been %s. To finish publishing visit %s/publishing/deployments", deploymentId, waitForDeploymentStateRequest.waitTypeName(), waitForDeploymentStateRequest.getCentralBaseUrl()));
    }
}

