/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

public class HashAlgorithm {
    public static final String MD5_NAME = "md5";
    public static final String SHA1_NAME = "sha1";
    public static final String SHA256_NAME = "sha256";
    public static final String SHA512_NAME = "sha512";
    public static final HashAlgorithm MD5 = new HashAlgorithm("md5", Hashing.md5());
    public static final HashAlgorithm SHA1 = new HashAlgorithm("sha1", Hashing.sha1());
    public static final HashAlgorithm SHA256 = new HashAlgorithm("sha256", Hashing.sha256());
    public static final HashAlgorithm SHA512 = new HashAlgorithm("sha512", Hashing.sha512());
    private final String name;
    private final HashFunction function;

    public HashAlgorithm(String name, HashFunction function) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.function = (HashFunction)Preconditions.checkNotNull((Object)function);
    }

    public String name() {
        return this.name;
    }

    public HashFunction function() {
        return this.function;
    }
}

