/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client.httpclient.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.sonatype.central.publisher.client.utils.PathUtils;

public class PublisherBundle {
    private final String name;
    private final Path path;
    private Set<Path> files = new HashSet<Path>();

    public PublisherBundle(String name, Path path) {
        this.name = name;
        this.path = path;
    }

    private PublisherBundle(BundleBuilder bundleBuilder) {
        this.name = bundleBuilder.bundleName;
        this.path = bundleBuilder.bundlePath;
        this.files = bundleBuilder.files;
    }

    public String getName() {
        return this.name;
    }

    public Path getPath() {
        return this.path;
    }

    public List<Path> getFiles() {
        return new ArrayList<Path>(this.files);
    }

    public static class BundleBuilder {
        private Path sourcePath;
        private Path destPath;
        private Path bundlePath;
        private String bundleName;
        private final Set<Path> files;

        public BundleBuilder(Path sourcePath) {
            this.sourcePath = sourcePath;
            this.destPath = sourcePath;
            this.bundleName = "bundle.zip";
            this.files = new HashSet<Path>();
        }

        public BundleBuilder sourcePath(Path sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public BundleBuilder destPath(Path destPath) {
            this.destPath = destPath;
            return this;
        }

        public BundleBuilder bundleName(String bundleName) {
            this.bundleName = bundleName;
            return this;
        }

        public BundleBuilder add(Path filePath) {
            this.files.add(filePath);
            return this;
        }

        public BundleBuilder addAll(Set<Path> files) {
            this.files.addAll(files);
            return this;
        }

        public BundleBuilder addAllSourceFiles() {
            try (Stream<Path> paths = Files.walk(this.sourcePath, new FileVisitOption[0]);){
                Set files = paths.filter(path -> path.toFile().isFile()).collect(Collectors.toSet());
                this.files.addAll(files);
            }
            catch (IOException e) {
                throw new RuntimeException("Error on source dir traversal", e);
            }
            return this;
        }

        public PublisherBundle build() {
            this.bundlePath = this.createBundle();
            return new PublisherBundle(this);
        }

        private Path createBundle() {
            Path newBundle = PathUtils.PathOf(this.destPath.toString(), this.bundleName);
            try {
                Files.createDirectories(newBundle.getParent(), new FileAttribute[0]);
                Files.deleteIfExists(newBundle);
                Files.createFile(newBundle, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("File already exists: " + newBundle);
            }
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(newBundle.toFile()));){
                for (Path filePath : this.files) {
                    Path fileRelativePath = this.sourcePath.relativize(filePath);
                    File bundleEntry = filePath.toFile();
                    if (!bundleEntry.isFile()) continue;
                    zipOutputStream.putNextEntry(new ZipEntry(fileRelativePath.toString()));
                    try (FileInputStream in = new FileInputStream(bundleEntry);){
                        IOUtils.copy((InputStream)in, (OutputStream)zipOutputStream);
                    }
                    zipOutputStream.closeEntry();
                }
                zipOutputStream.finish();
            }
            catch (Exception e) {
                throw new RuntimeException("Error on bundle creation", e);
            }
            return newBundle;
        }
    }
}

