/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.client.httpclient;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.BasicHttpClientResponseHandler;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.net.URIBuilder;
import org.sonatype.central.publisher.client.httpclient.RequestType;
import org.sonatype.central.publisher.client.httpclient.auth.AuthProvider;

public class PublisherHttpClient {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendRequest(AuthProvider authProvider, String endpointUrl, Map<String, String> params, Path body, RequestType requestType) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(endpointUrl);
            params.forEach((arg_0, arg_1) -> ((URIBuilder)uriBuilder).addParameter(arg_0, arg_1));
            switch (requestType) {
                case POST: {
                    HttpPost httpPost = new HttpPost(uriBuilder.build());
                    authProvider.getAuthHeaders().forEach((arg_0, arg_1) -> ((HttpPost)httpPost).addHeader(arg_0, arg_1));
                    if (body != null) {
                        File file = body.toFile();
                        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                        builder.setMode(HttpMultipartMode.LEGACY);
                        builder.addBinaryBody("bundle", file, ContentType.APPLICATION_OCTET_STREAM, file.getName());
                        httpPost.setEntity(builder.build());
                    }
                    try (CloseableHttpClient client = HttpClients.createDefault();){
                        String string = (String)client.execute((ClassicHttpRequest)httpPost, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
                        return string;
                    }
                }
            }
            HttpDelete httpRequest = requestType == RequestType.DELETE ? new HttpDelete(uriBuilder.build()) : new HttpGet(uriBuilder.build());
            authProvider.getAuthHeaders().forEach((arg_0, arg_1) -> ((HttpUriRequestBase)httpRequest).addHeader(arg_0, arg_1));
            try (CloseableHttpClient client = HttpClients.createDefault();){
                String string = (String)client.execute((ClassicHttpRequest)httpRequest, (HttpClientResponseHandler)new BasicHttpClientResponseHandler());
                return string;
            }
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

