/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.models.DatasetFieldId;
import marquez.client.models.DatasetFieldVersionId;
import marquez.client.models.DatasetId;
import marquez.client.models.DatasetVersionId;
import marquez.client.models.JobId;
import marquez.client.models.JobVersionId;

@JsonDeserialize(converter=FromValue.class)
@JsonSerialize(converter=ToValue.class)
public final class NodeId
implements Comparable<NodeId> {
    public static final String ID_DELIM = ":";
    public static final Joiner ID_JOINER = Joiner.on((String)":");
    private static final String ID_PREFX_DATASET = "dataset";
    private static final String ID_PREFX_DATASET_FIELD = "datasetField";
    private static final String ID_PREFX_JOB = "job";
    private static final String ID_PREFX_RUN = "run";
    private static final Pattern ID_PATTERN = Pattern.compile(String.format("^(%s|%s|%s|%s):.*$", "dataset", "datasetField", "job", "run"));
    public static final String VERSION_DELIM = "#";
    private final String value;

    public NodeId(String value) {
        Preconditions.checkArgument((boolean)ID_PATTERN.matcher(value).matches(), (String)"node ID (%s) must start with '%s', '%s', '%s' or '%s'", (Object[])new Object[]{value, ID_PREFX_DATASET, ID_PREFX_DATASET_FIELD, ID_PREFX_JOB, ID_PREFX_RUN});
        this.value = value;
    }

    public static NodeId of(String value) {
        return new NodeId(value);
    }

    public static NodeId of(@NonNull DatasetId datasetId) {
        Objects.requireNonNull(datasetId, "datasetId is marked non-null but is null");
        return NodeId.of(ID_JOINER.join((Object)ID_PREFX_DATASET, (Object)datasetId.getNamespace(), new Object[]{datasetId.getName()}));
    }

    public static NodeId of(@NonNull DatasetFieldId datasetFieldId) {
        Objects.requireNonNull(datasetFieldId, "datasetFieldId is marked non-null but is null");
        return NodeId.of(ID_JOINER.join((Object)ID_PREFX_DATASET_FIELD, (Object)datasetFieldId.getNamespace(), new Object[]{datasetFieldId.getDataset(), datasetFieldId.getField()}));
    }

    public static NodeId of(@NonNull JobId jobId) {
        Objects.requireNonNull(jobId, "jobId is marked non-null but is null");
        return NodeId.of(ID_JOINER.join((Object)ID_PREFX_JOB, (Object)jobId.getNamespace(), new Object[]{jobId.getName()}));
    }

    public static NodeId of(@NonNull DatasetFieldVersionId datasetFieldVersionId) {
        Objects.requireNonNull(datasetFieldVersionId, "datasetFieldVersionId is marked non-null but is null");
        return NodeId.of(NodeId.appendVersionTo(ID_JOINER.join((Object)ID_PREFX_DATASET_FIELD, (Object)datasetFieldVersionId.getNamespace(), new Object[]{datasetFieldVersionId.getName(), datasetFieldVersionId.getField()}), datasetFieldVersionId.getVersion()));
    }

    public static NodeId of(@NonNull JobVersionId jobVersionId) {
        Objects.requireNonNull(jobVersionId, "jobVersionId is marked non-null but is null");
        return NodeId.of(new JobId(jobVersionId.getNamespace(), NodeId.appendVersionTo(jobVersionId.getName(), jobVersionId.getVersion())));
    }

    public static NodeId of(@NonNull DatasetVersionId versionId) {
        Objects.requireNonNull(versionId, "versionId is marked non-null but is null");
        return NodeId.of(new DatasetId(versionId.getNamespace(), NodeId.appendVersionTo(versionId.getName(), versionId.getVersion())));
    }

    @JsonIgnore
    public boolean isDatasetFieldType() {
        return this.value.startsWith(ID_PREFX_DATASET_FIELD);
    }

    @JsonIgnore
    public boolean isDatasetType() {
        return this.value.startsWith("dataset:");
    }

    @JsonIgnore
    public boolean isJobType() {
        return this.value.startsWith(ID_PREFX_JOB);
    }

    @JsonIgnore
    public boolean isDatasetFieldVersionType() {
        return this.value.startsWith(ID_PREFX_DATASET_FIELD) && this.hasVersion();
    }

    @JsonIgnore
    public boolean isDatasetVersionType() {
        return this.value.startsWith(ID_PREFX_DATASET) && this.hasVersion();
    }

    @JsonIgnore
    public boolean isJobVersionType() {
        return this.value.startsWith(ID_PREFX_JOB) && this.hasVersion();
    }

    @JsonIgnore
    public boolean hasVersion() {
        return this.value.contains(VERSION_DELIM);
    }

    @JsonIgnore
    private String[] parts(int expectedParts, String expectedType) {
        String[] parts = this.value.split(":|#");
        if (parts.length < expectedParts) {
            throw new UnsupportedOperationException(String.format("Expected NodeId of type %s with %s parts. Got: %s", expectedType, expectedParts, this.getValue()));
        }
        if (parts.length == expectedParts) {
            return parts;
        }
        Pattern p = Pattern.compile("(?::(?!//|\\d+))");
        Matcher matcher = p.matcher(this.value);
        String[] returnParts = new String[expectedParts];
        int prevIndex = 0;
        for (int i = 0; i < expectedParts - 1; ++i) {
            matcher.find();
            int index = matcher.start();
            returnParts[i] = this.value.substring(prevIndex, index);
            prevIndex = matcher.end();
        }
        returnParts[expectedParts - 1] = this.value.substring(prevIndex);
        return returnParts;
    }

    @JsonIgnore
    public DatasetId asDatasetId() {
        String[] parts = this.parts(3, ID_PREFX_DATASET);
        return new DatasetId(parts[1], parts[2]);
    }

    @JsonIgnore
    public DatasetFieldId asDatasetFieldId() {
        String[] parts = this.parts(4, ID_PREFX_DATASET);
        return new DatasetFieldId(parts[1], parts[2], parts[3]);
    }

    @JsonIgnore
    public JobId asJobId() {
        String[] parts = this.parts(3, ID_PREFX_JOB);
        return new JobId(parts[1], parts[2]);
    }

    @JsonIgnore
    public DatasetFieldVersionId asDatasetFieldVersionId() {
        String[] parts = this.parts(4, ID_PREFX_DATASET_FIELD);
        String[] nameAndVersion = parts[3].split(VERSION_DELIM);
        return new DatasetFieldVersionId(parts[1], parts[2], nameAndVersion[0], UUID.fromString(nameAndVersion[1]));
    }

    @JsonIgnore
    public JobVersionId asJobVersionId() {
        String[] parts = this.parts(3, ID_PREFX_JOB);
        String[] nameAndVersion = parts[2].split(VERSION_DELIM);
        return new JobVersionId(parts[1], nameAndVersion[0], UUID.fromString(nameAndVersion[1]));
    }

    @JsonIgnore
    public DatasetVersionId asDatasetVersionId() {
        String[] parts = this.parts(3, ID_PREFX_DATASET);
        String[] nameAndVersion = parts[2].split(VERSION_DELIM);
        return new DatasetVersionId(parts[1], nameAndVersion[0], UUID.fromString(nameAndVersion[1]));
    }

    @Override
    public int compareTo(NodeId o) {
        return this.value.compareTo(o.getValue());
    }

    private static String appendVersionTo(@NonNull String value, @Nullable UUID version) {
        Objects.requireNonNull(value, "value is marked non-null but is null");
        return version == null ? value : value + VERSION_DELIM + version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NodeId)) {
            return false;
        }
        NodeId other = (NodeId)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NodeId(value=" + this.getValue() + ")";
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    public static class ToValue
    extends StdConverter<NodeId, String> {
        public String convert(@NonNull NodeId id) {
            Objects.requireNonNull(id, "id is marked non-null but is null");
            return id.getValue();
        }
    }

    public static class FromValue
    extends StdConverter<String, NodeId> {
        public NodeId convert(@NonNull String value) {
            Objects.requireNonNull(value, "value is marked non-null but is null");
            return NodeId.of(value);
        }
    }
}

