/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.google.common.collect.ImmutableSet;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;
import marquez.client.models.DatasetId;
import marquez.client.models.JobType;

public class JobMeta {
    private final JobType type;
    private final Set<DatasetId> inputs;
    private final Set<DatasetId> outputs;
    @Nullable
    private final URL location;
    @Nullable
    String description;
    @Nullable
    String runId;

    public JobMeta(@NonNull JobType type, @NonNull Set<DatasetId> inputs, @NonNull Set<DatasetId> outputs, @Nullable URL location, @Nullable String description, @Nullable String runId) {
        Objects.requireNonNull(type, "type is marked non-null but is null");
        Objects.requireNonNull(inputs, "inputs is marked non-null but is null");
        Objects.requireNonNull(outputs, "outputs is marked non-null but is null");
        this.type = type;
        this.inputs = inputs;
        this.outputs = outputs;
        this.location = location;
        this.description = description;
        this.runId = runId;
    }

    public Optional<URL> getLocation() {
        return Optional.ofNullable(this.location);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getRunId() {
        return Optional.ofNullable(this.runId);
    }

    public String toJson() {
        return Utils.toJson(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JobMeta)) {
            return false;
        }
        JobMeta other = (JobMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JobType this$type = this.getType();
        JobType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Set<DatasetId> this$inputs = this.getInputs();
        Set<DatasetId> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Set<DatasetId> this$outputs = this.getOutputs();
        Set<DatasetId> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Optional<URL> this$location = this.getLocation();
        Optional<URL> other$location = other.getLocation();
        if (this$location == null ? other$location != null : !((Object)this$location).equals(other$location)) {
            return false;
        }
        Optional<String> this$description = this.getDescription();
        Optional<String> other$description = other.getDescription();
        if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
            return false;
        }
        Optional<String> this$runId = this.getRunId();
        Optional<String> other$runId = other.getRunId();
        return !(this$runId == null ? other$runId != null : !((Object)this$runId).equals(other$runId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JobMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JobType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Set<DatasetId> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Set<DatasetId> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Optional<URL> $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        Optional<String> $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
        Optional<String> $runId = this.getRunId();
        result = result * 59 + ($runId == null ? 43 : ((Object)$runId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JobMeta(type=" + this.getType() + ", inputs=" + this.getInputs() + ", outputs=" + this.getOutputs() + ", location=" + this.getLocation() + ", description=" + this.getDescription() + ", runId=" + this.getRunId() + ")";
    }

    @Generated
    public JobType getType() {
        return this.type;
    }

    @Generated
    public Set<DatasetId> getInputs() {
        return this.inputs;
    }

    @Generated
    public Set<DatasetId> getOutputs() {
        return this.outputs;
    }

    public static final class Builder {
        private JobType type;
        private Set<DatasetId> inputs = ImmutableSet.of();
        private Set<DatasetId> outputs = ImmutableSet.of();
        @Nullable
        private URL location;
        @Nullable
        private String description;
        @Nullable
        String runId;

        private Builder() {
        }

        public Builder type(@NonNull String typeString) {
            Objects.requireNonNull(typeString, "typeString is marked non-null but is null");
            return this.type(JobType.valueOf(typeString));
        }

        public Builder type(@NonNull JobType type) {
            Objects.requireNonNull(type, "type is marked non-null but is null");
            this.type = type;
            return this;
        }

        public Builder inputs(@NonNull String namespaceName, String ... datasetNames) {
            Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
            ImmutableSet.Builder datasetIds = ImmutableSet.builder();
            for (String datasetName : datasetNames) {
                datasetIds.add((Object)new DatasetId(namespaceName, datasetName));
            }
            this.inputs((Set<DatasetId>)datasetIds.build());
            return this;
        }

        public Builder inputs(@NonNull Set<DatasetId> inputs) {
            Objects.requireNonNull(inputs, "inputs is marked non-null but is null");
            this.inputs = ImmutableSet.copyOf(inputs);
            return this;
        }

        public Builder outputs(@NonNull String namespaceName, String ... datasetNames) {
            Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
            ImmutableSet.Builder datasetIds = ImmutableSet.builder();
            for (String datasetName : datasetNames) {
                datasetIds.add((Object)new DatasetId(namespaceName, datasetName));
            }
            this.outputs((Set<DatasetId>)datasetIds.build());
            return this;
        }

        public Builder outputs(@NonNull Set<DatasetId> outputs) {
            Objects.requireNonNull(outputs, "outputs is marked non-null but is null");
            this.outputs = ImmutableSet.copyOf(outputs);
            return this;
        }

        public Builder location(@NonNull String locationString) {
            Objects.requireNonNull(locationString, "locationString is marked non-null but is null");
            return this.location(Utils.toUrl(locationString));
        }

        public Builder location(@NonNull URL location) {
            Objects.requireNonNull(location, "location is marked non-null but is null");
            this.location = location;
            return this;
        }

        public Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public Builder runId(@Nullable String runId) {
            this.runId = runId;
            return this;
        }

        public JobMeta build() {
            return new JobMeta(this.type, this.inputs, this.outputs, this.location, this.description, this.runId);
        }
    }
}

