/*
 * Decompiled with CFR 0.152.
 */
package marquez.client.models;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.Utils;
import marquez.client.models.DatasetId;
import marquez.client.models.JobId;
import marquez.client.models.JobMeta;
import marquez.client.models.JobType;
import marquez.client.models.Run;

public final class Job
extends JobMeta {
    private final JobId id;
    private final String name;
    private final String simpleName;
    private final String parentJobName;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String namespace;
    @Nullable
    private final Run latestRun;
    private final Map<String, Object> facets;
    @Nullable
    private final UUID currentVersion;

    public Job(@NonNull JobId id, JobType type, @NonNull String name, @NonNull String simpleName, String parentJobName, @NonNull Instant createdAt, @NonNull Instant updatedAt, @NonNull String namespace, Set<DatasetId> inputs, Set<DatasetId> outputs, @Nullable URL location, String description, @Nullable Run latestRun, @Nullable Map<String, Object> facets, @Nullable UUID currentVersion) {
        super(type, inputs, outputs, location, description, null);
        Objects.requireNonNull(id, "id is marked non-null but is null");
        Objects.requireNonNull(name, "name is marked non-null but is null");
        Objects.requireNonNull(simpleName, "simpleName is marked non-null but is null");
        Objects.requireNonNull(createdAt, "createdAt is marked non-null but is null");
        Objects.requireNonNull(updatedAt, "updatedAt is marked non-null but is null");
        Objects.requireNonNull(namespace, "namespace is marked non-null but is null");
        this.id = id;
        this.name = name;
        this.simpleName = simpleName;
        this.parentJobName = parentJobName;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.namespace = namespace;
        this.latestRun = latestRun;
        this.facets = facets == null ? ImmutableMap.of() : ImmutableMap.copyOf(facets);
        this.currentVersion = currentVersion;
    }

    public Optional<Run> getLatestRun() {
        return Optional.ofNullable(this.latestRun);
    }

    public boolean hasFacets() {
        return !this.facets.isEmpty();
    }

    public static Job fromJson(@NonNull String json) {
        Objects.requireNonNull(json, "json is marked non-null but is null");
        return Utils.fromJson(json, new TypeReference<Job>(){});
    }

    public Optional<UUID> getCurrentVersion() {
        return Optional.ofNullable(this.currentVersion);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Job)) {
            return false;
        }
        Job other = (Job)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobId this$id = this.getId();
        JobId other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$simpleName = this.getSimpleName();
        String other$simpleName = other.getSimpleName();
        if (this$simpleName == null ? other$simpleName != null : !this$simpleName.equals(other$simpleName)) {
            return false;
        }
        String this$parentJobName = this.getParentJobName();
        String other$parentJobName = other.getParentJobName();
        if (this$parentJobName == null ? other$parentJobName != null : !this$parentJobName.equals(other$parentJobName)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Optional<Run> this$latestRun = this.getLatestRun();
        Optional<Run> other$latestRun = other.getLatestRun();
        if (this$latestRun == null ? other$latestRun != null : !((Object)this$latestRun).equals(other$latestRun)) {
            return false;
        }
        Map<String, Object> this$facets = this.getFacets();
        Map<String, Object> other$facets = other.getFacets();
        if (this$facets == null ? other$facets != null : !((Object)this$facets).equals(other$facets)) {
            return false;
        }
        Optional<UUID> this$currentVersion = this.getCurrentVersion();
        Optional<UUID> other$currentVersion = other.getCurrentVersion();
        return !(this$currentVersion == null ? other$currentVersion != null : !((Object)this$currentVersion).equals(other$currentVersion));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Job;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        JobId $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $simpleName = this.getSimpleName();
        result = result * 59 + ($simpleName == null ? 43 : $simpleName.hashCode());
        String $parentJobName = this.getParentJobName();
        result = result * 59 + ($parentJobName == null ? 43 : $parentJobName.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Optional<Run> $latestRun = this.getLatestRun();
        result = result * 59 + ($latestRun == null ? 43 : ((Object)$latestRun).hashCode());
        Map<String, Object> $facets = this.getFacets();
        result = result * 59 + ($facets == null ? 43 : ((Object)$facets).hashCode());
        Optional<UUID> $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 43 : ((Object)$currentVersion).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Job(super=" + super.toString() + ", id=" + this.getId() + ", name=" + this.getName() + ", simpleName=" + this.getSimpleName() + ", parentJobName=" + this.getParentJobName() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", namespace=" + this.getNamespace() + ", latestRun=" + this.getLatestRun() + ", facets=" + this.getFacets() + ", currentVersion=" + this.getCurrentVersion() + ")";
    }

    @Generated
    public JobId getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getSimpleName() {
        return this.simpleName;
    }

    @Generated
    public String getParentJobName() {
        return this.parentJobName;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Map<String, Object> getFacets() {
        return this.facets;
    }
}

