/*
 * Decompiled with CFR 0.152.
 */
package marquez.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import lombok.NonNull;
import org.apache.http.client.methods.HttpRequestBase;

public final class Utils {
    private static final ObjectMapper MAPPER = Utils.newObjectMapper();

    private Utils() {
    }

    public static ObjectMapper getMapper() {
        return MAPPER;
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = Jackson.newObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        return mapper;
    }

    public static String toJson(@NonNull Object value) {
        Objects.requireNonNull(value, "value is marked non-null but is null");
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static <T> T fromJson(@NonNull String json, @NonNull TypeReference<T> type) {
        Objects.requireNonNull(json, "json is marked non-null but is null");
        Objects.requireNonNull(type, "type is marked non-null but is null");
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static URL toUrl(@NonNull String urlString) {
        Objects.requireNonNull(urlString, "urlString is marked non-null but is null");
        try {
            String url = urlString;
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            return new URL(url);
        }
        catch (MalformedURLException e) {
            AssertionError error = new AssertionError((Object)("Malformed URL: " + urlString));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }

    public static void addAuthTo(@NonNull HttpRequestBase request, @NonNull String apiKey) {
        Objects.requireNonNull(request, "request is marked non-null but is null");
        Objects.requireNonNull(apiKey, "apiKey is marked non-null but is null");
        request.addHeader("Authorization", "Bearer " + apiKey);
    }

    public static String checkNotBlank(@NonNull String arg) {
        Objects.requireNonNull(arg, "arg is marked non-null but is null");
        if (Utils.emptyOrBlank(arg)) {
            throw new IllegalArgumentException();
        }
        return arg;
    }

    private static boolean emptyOrBlank(String arg) {
        return arg.trim().isEmpty();
    }
}

