/*
 * Decompiled with CFR 0.152.
 */
package marquez.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import lombok.NonNull;
import marquez.client.MarquezClient;
import marquez.client.MarquezPathV1;
import marquez.client.models.NodeId;
import marquez.client.models.RunState;
import marquez.client.models.SearchFilter;
import marquez.client.models.SearchSort;
import org.apache.http.client.utils.URIBuilder;

class MarquezUrl {
    @VisibleForTesting
    final URL baseUrl;

    static MarquezUrl create(URL url) {
        return new MarquezUrl(url);
    }

    MarquezUrl(URL baseUrl) {
        this.baseUrl = baseUrl;
    }

    @VisibleForTesting
    URL from(String path) {
        return this.from(path, (Map<String, Object>)ImmutableMap.of());
    }

    @VisibleForTesting
    URL from(String path, @Nullable Map<String, Object> queryParams) {
        try {
            URIBuilder builder = new URIBuilder(URI.create(this.baseUrl.toURI() + path));
            if (queryParams != null) {
                queryParams.forEach((name, value) -> builder.addParameter(name, String.valueOf(value)));
            }
            return builder.build().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("can not build url from parameters: " + path + " " + queryParams, e);
        }
    }

    private Map<String, Object> newQueryParamsWith(int limit, int offset) {
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"limit must be >= 0");
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
        return ImmutableMap.of((Object)"limit", (Object)limit, (Object)"offset", (Object)offset);
    }

    URL toListNamespacesUrl(int limit, int offset) {
        return this.from(MarquezPathV1.listNamespacesPath(), this.newQueryParamsWith(limit, offset));
    }

    URL toNamespaceUrl(String namespaceName) {
        return this.from(MarquezPathV1.namespacePath(namespaceName));
    }

    URL toEventUrl(MarquezClient.SortDirection sort, int limit) {
        return this.toEventUrl(sort, null, null, limit);
    }

    URL toEventUrl(@Nullable MarquezClient.SortDirection sort, @Nullable ZonedDateTime before, @Nullable ZonedDateTime after, int limit) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        if (sort != null) {
            queryParams.put("sortDirection", sort.getValue());
        }
        if (before != null) {
            queryParams.put("before", before.toOffsetDateTime().toString());
        }
        if (after != null) {
            queryParams.put("after", after.toOffsetDateTime().toString());
        }
        queryParams.put("limit", limit);
        return this.from(MarquezPathV1.lineageEventPath(), queryParams);
    }

    URL toSourceUrl(String sourceName) {
        return this.from(MarquezPathV1.sourcePath(sourceName));
    }

    URL toDatasetUrl(String namespaceName, String datasetName) {
        return this.from(MarquezPathV1.datasetPath(namespaceName, datasetName));
    }

    URL toListJobsUrl(@NonNull String namespaceName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return this.from(MarquezPathV1.listJobsPath(namespaceName), this.newQueryParamsWith(limit, offset));
    }

    URL toJobUrl(String namespaceName, String jobName) {
        return this.from(MarquezPathV1.jobPath(namespaceName, jobName));
    }

    URL toListJobVersionsUrl(@NonNull String namespaceName, String jobName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return this.from(MarquezPathV1.listJobVersionsPath(namespaceName, jobName), this.newQueryParamsWith(limit, offset));
    }

    URL toJobVersionUrl(String namespaceName, String jobName, String version) {
        return this.from(MarquezPathV1.jobVersionPath(namespaceName, jobName, version));
    }

    URL toCreateRunUrl(String namespaceName, String jobName) {
        return this.from(MarquezPathV1.createRunPath(namespaceName, jobName));
    }

    URL toRunUrl(@NonNull String runId) {
        Objects.requireNonNull(runId, "runId is marked non-null but is null");
        return this.from(MarquezPathV1.runPath(runId));
    }

    URL toListRunsUrl(@NonNull String namespaceName, @NonNull String jobName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        return this.from(MarquezPathV1.listRunsPath(namespaceName, jobName), this.newQueryParamsWith(limit, offset));
    }

    URL toRunTransitionUrl(String runId, RunState runState, Instant at) {
        return this.from(MarquezPathV1.runTransitionPath(runId, runState), (Map<String, Object>)(at == null ? ImmutableMap.of() : ImmutableMap.of((Object)"at", (Object)DateTimeFormatter.ISO_INSTANT.format(at))));
    }

    URL toListSourcesUrl(int limit, int offset) {
        return this.from(MarquezPathV1.listSourcesPath(), this.newQueryParamsWith(limit, offset));
    }

    URL toListDatasetsUrl(@NonNull String namespaceName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return this.from(MarquezPathV1.listDatasetsPath(namespaceName), this.newQueryParamsWith(limit, offset));
    }

    URL toDatasetVersionUrl(String namespaceName, String datasetName, String version) {
        return this.from(MarquezPathV1.datasetVersionPath(namespaceName, datasetName, version));
    }

    URL toListDatasetVersionsUrl(@NonNull String namespaceName, @NonNull String datasetName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        return this.from(MarquezPathV1.listDatasetVersionsPath(namespaceName, datasetName), this.newQueryParamsWith(limit, offset));
    }

    URL toDatasetTagUrl(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String tagName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(tagName, "tagName is marked non-null but is null");
        return this.from(MarquezPathV1.datasetTagPath(namespaceName, datasetName, tagName));
    }

    URL toFieldTagURL(String namespaceName, String datasetName, String fieldName, String tagName) {
        return this.from(MarquezPathV1.fieldTagPath(namespaceName, datasetName, fieldName, tagName));
    }

    URL toListTagsUrl(int limit, int offset) {
        return this.from(MarquezPathV1.listTagsPath(), this.newQueryParamsWith(limit, offset));
    }

    URL toCreateTagsUrl(String name) {
        return this.from(MarquezPathV1.createTagPath(name));
    }

    URL toSearchUrl(@NonNull String query, @Nullable SearchFilter filter, @Nullable SearchSort sort, int limit) {
        Objects.requireNonNull(query, "query is marked non-null but is null");
        ImmutableMap.Builder queryParams = new ImmutableMap.Builder();
        queryParams.put((Object)"q", (Object)query);
        if (filter != null) {
            queryParams.put((Object)"filter", (Object)filter);
        }
        if (filter != null) {
            queryParams.put((Object)"sort", (Object)sort);
        }
        queryParams.put((Object)"limit", (Object)limit);
        return this.from(MarquezPathV1.searchPath(), (Map<String, Object>)queryParams.build());
    }

    URL toLineageUrl(NodeId nodeId, int depth) {
        ImmutableMap.Builder queryParams = new ImmutableMap.Builder();
        queryParams.put((Object)"nodeId", (Object)nodeId.getValue());
        queryParams.put((Object)"depth", (Object)String.valueOf(depth));
        return this.from(MarquezPathV1.lineagePath(), (Map<String, Object>)queryParams.build());
    }

    URL toColumnLineageUrl(NodeId nodeId, int depth, boolean withDownstream) {
        ImmutableMap.Builder queryParams = new ImmutableMap.Builder();
        queryParams.put((Object)"nodeId", (Object)nodeId.getValue());
        queryParams.put((Object)"depth", (Object)String.valueOf(depth));
        queryParams.put((Object)"withDownstream", (Object)String.valueOf(withDownstream));
        return this.from(MarquezPathV1.columnLineagePath(), (Map<String, Object>)queryParams.build());
    }
}

