/*
 * Decompiled with CFR 0.152.
 */
package marquez.client;

import com.google.common.annotations.VisibleForTesting;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import marquez.client.MarquezClientException;
import marquez.client.models.RunState;
import org.apache.commons.lang3.StringUtils;

class MarquezPathV1 {
    @VisibleForTesting
    static final String BASE_PATH = "/api/v1";

    MarquezPathV1() {
    }

    @VisibleForTesting
    static String path(String pathTemplate, String ... pathArgs) {
        int argsLength;
        int n = argsLength = pathArgs == null ? 0 : pathArgs.length;
        if (StringUtils.countMatches((CharSequence)pathTemplate, (CharSequence)"%s") != argsLength) {
            throw new MarquezClientException(String.format("Amount of placeholders %s differ from amount of provided path arguments %s", ((String)pathTemplate).split("%s").length - 1, argsLength));
        }
        pathTemplate = BASE_PATH + (String)pathTemplate;
        if (pathArgs == null) {
            return pathTemplate;
        }
        Iterator iterator = Arrays.stream(pathArgs).iterator();
        return Stream.of(((String)pathTemplate).split("/")).filter(it -> it != null && !it.isEmpty()).map(it -> it.equals("%s") ? (String)iterator.next() : it).map(MarquezPathV1::encode).collect(Collectors.joining("/", "/", ""));
    }

    static String encode(String input) {
        try {
            return URLEncoder.encode(input, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new MarquezClientException(e);
        }
    }

    static String listNamespacesPath() {
        return MarquezPathV1.path("/namespaces", new String[0]);
    }

    static String namespacePath(String namespaceName) {
        return MarquezPathV1.path("/namespaces/%s", namespaceName);
    }

    static String lineageEventPath() {
        return MarquezPathV1.path("/events/lineage", new String[0]);
    }

    static String sourcePath(String sourceName) {
        return MarquezPathV1.path("/sources/%s", sourceName);
    }

    static String listSourcesPath() {
        return MarquezPathV1.path("/sources", new String[0]);
    }

    static String datasetVersionPath(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String version) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(version, "version is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/datasets/%s/versions/%s", namespaceName, datasetName, version);
    }

    static String listDatasetVersionsPath(@NonNull String namespaceName, @NonNull String datasetName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/datasets/%s/versions", namespaceName, datasetName);
    }

    static String listDatasetsPath(@NonNull String namespaceName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/datasets", namespaceName);
    }

    static String datasetPath(String namespaceName, String datasetName) {
        return MarquezPathV1.path("/namespaces/%s/datasets/%s", namespaceName, datasetName);
    }

    static String listJobsPath(@NonNull String namespaceName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/jobs", namespaceName);
    }

    static String jobPath(String namespaceName, String jobName) {
        return MarquezPathV1.path("/namespaces/%s/jobs/%s", namespaceName, jobName);
    }

    static String listJobVersionsPath(@NonNull String namespaceName, String jobName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/jobs/%s/versions", namespaceName, jobName);
    }

    static String jobVersionPath(String namespaceName, String jobName, String version) {
        return MarquezPathV1.path("/namespaces/%s/jobs/%s/versions/%s", namespaceName, jobName, version);
    }

    static String createRunPath(String namespaceName, String jobName) {
        return MarquezPathV1.path("/namespaces/%s/jobs/%s/runs", namespaceName, jobName);
    }

    static String runPath(@NonNull String runId) {
        Objects.requireNonNull(runId, "runId is marked non-null but is null");
        return MarquezPathV1.path("/jobs/runs/%s", runId);
    }

    static String listRunsPath(@NonNull String namespaceName, @NonNull String jobName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/jobs/%s/runs", namespaceName, jobName);
    }

    static String runTransitionPath(String runId, RunState runState) {
        return MarquezPathV1.path("/jobs/runs/%s/%s", runId, switch (runState) {
            case RunState.RUNNING -> "start";
            case RunState.COMPLETED -> "complete";
            case RunState.ABORTED -> "abort";
            case RunState.FAILED -> "fail";
            default -> throw new IllegalArgumentException(String.format("Unexpected run state: %s", runState.name()));
        });
    }

    static String datasetTagPath(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String tagName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(tagName, "tagName is marked non-null but is null");
        return MarquezPathV1.path("/namespaces/%s/datasets/%s/tags/%s", namespaceName, datasetName, tagName);
    }

    static String fieldTagPath(String namespaceName, String datasetName, String fieldName, String tagName) {
        return MarquezPathV1.path("/namespaces/%s/datasets/%s/fields/%s/tags/%s", namespaceName, datasetName, fieldName, tagName);
    }

    static String listTagsPath() {
        return MarquezPathV1.path("/tags", new String[0]);
    }

    static String createTagPath(String name) {
        return MarquezPathV1.path("/tags/%s", name);
    }

    static String searchPath() {
        return MarquezPathV1.path("/search", new String[0]);
    }

    static String lineagePath() {
        return MarquezPathV1.path("/lineage/", new String[0]);
    }

    static String columnLineagePath() {
        return MarquezPathV1.path("/column-lineage/", new String[0]);
    }
}

