/*
 * Decompiled with CFR 0.152.
 */
package marquez.client;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import lombok.NonNull;
import marquez.client.MarquezHttp;
import marquez.client.MarquezUrl;
import marquez.client.Utils;
import marquez.client.models.Dataset;
import marquez.client.models.DatasetMeta;
import marquez.client.models.DatasetVersion;
import marquez.client.models.Job;
import marquez.client.models.JobMeta;
import marquez.client.models.JobVersion;
import marquez.client.models.LineageEvent;
import marquez.client.models.Namespace;
import marquez.client.models.NamespaceMeta;
import marquez.client.models.Node;
import marquez.client.models.NodeId;
import marquez.client.models.Run;
import marquez.client.models.RunMeta;
import marquez.client.models.RunState;
import marquez.client.models.SearchFilter;
import marquez.client.models.SearchResults;
import marquez.client.models.SearchSort;
import marquez.client.models.Source;
import marquez.client.models.SourceMeta;
import marquez.client.models.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarquezClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MarquezClient.class);
    static final URL DEFAULT_BASE_URL = Utils.toUrl("http://localhost:8080");
    static final int DEFAULT_LINEAGE_GRAPH_DEPTH = 20;
    @VisibleForTesting
    static final int DEFAULT_LIMIT = 100;
    @VisibleForTesting
    static final int DEFAULT_OFFSET = 0;
    @VisibleForTesting
    final MarquezUrl url;
    @VisibleForTesting
    final MarquezHttp http;

    public MarquezClient() {
        this(DEFAULT_BASE_URL, null);
    }

    public MarquezClient(String baseUrlString) {
        this(baseUrlString, null);
    }

    public MarquezClient(String baseUrlString, @Nullable String apiKey) {
        this(Utils.toUrl(baseUrlString), apiKey);
    }

    public MarquezClient(URL baseUrl) {
        this(baseUrl, null);
    }

    public MarquezClient(URL baseUrl, @Nullable String apiKey) {
        this(MarquezUrl.create(baseUrl), MarquezHttp.create(Version.get(), apiKey));
    }

    @VisibleForTesting
    MarquezClient(@NonNull MarquezUrl url, @NonNull MarquezHttp http) {
        Objects.requireNonNull(url, "url is marked non-null but is null");
        Objects.requireNonNull(http, "http is marked non-null but is null");
        this.url = url;
        this.http = http;
    }

    public List<LineageEvent> listLineageEvents() {
        return this.listLineageEvents(SortDirection.DESC, 100);
    }

    public List<LineageEvent> listLineageEvents(SortDirection sort, int limit) {
        String bodyAsJson = this.http.get(this.url.toEventUrl(sort, limit));
        return Events.fromJson(bodyAsJson).getValue();
    }

    public List<LineageEvent> listLineageEvents(SortDirection sort, ZonedDateTime before, ZonedDateTime after, int limit) {
        String bodyAsJson = this.http.get(this.url.toEventUrl(sort, before, after, limit));
        return Events.fromJson(bodyAsJson).getValue();
    }

    public Lineage getLineage(NodeId nodeId) {
        return this.getLineage(nodeId, 20);
    }

    public Lineage getLineage(NodeId nodeId, int depth) {
        String bodyAsJson = this.http.get(this.url.toLineageUrl(nodeId, depth));
        return Lineage.fromJson(bodyAsJson);
    }

    public Lineage getColumnLineage(NodeId nodeId) {
        return this.getColumnLineage(nodeId, 20, false);
    }

    public Lineage getColumnLineage(NodeId nodeId, int depth, boolean withDownstream) {
        String bodyAsJson = this.http.get(this.url.toColumnLineageUrl(nodeId, depth, withDownstream));
        return Lineage.fromJson(bodyAsJson);
    }

    public Namespace createNamespace(@NonNull String namespaceName, @NonNull NamespaceMeta namespaceMeta) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(namespaceMeta, "namespaceMeta is marked non-null but is null");
        String bodyAsJson = this.http.put(this.url.toNamespaceUrl(namespaceName), namespaceMeta.toJson());
        return Namespace.fromJson(bodyAsJson);
    }

    public Namespace getNamespace(@NonNull String namespaceName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toNamespaceUrl(namespaceName));
        return Namespace.fromJson(bodyAsJson);
    }

    public List<Namespace> listNamespaces() {
        return this.listNamespaces(100, 0);
    }

    public List<Namespace> listNamespaces(int limit, int offset) {
        String bodyAsJson = this.http.get(this.url.toListNamespacesUrl(limit, offset));
        return Namespaces.fromJson(bodyAsJson).getValue();
    }

    public Source createSource(@NonNull String sourceName, @NonNull SourceMeta sourceMeta) {
        Objects.requireNonNull(sourceName, "sourceName is marked non-null but is null");
        Objects.requireNonNull(sourceMeta, "sourceMeta is marked non-null but is null");
        String bodyAsJson = this.http.put(this.url.toSourceUrl(sourceName), sourceMeta.toJson());
        return Source.fromJson(bodyAsJson);
    }

    public Source getSource(@NonNull String sourceName) {
        Objects.requireNonNull(sourceName, "sourceName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toSourceUrl(sourceName));
        return Source.fromJson(bodyAsJson);
    }

    public List<Source> listSources() {
        return this.listSources(100, 0);
    }

    public List<Source> listSources(int limit, int offset) {
        String bodyAsJson = this.http.get(this.url.toListSourcesUrl(limit, offset));
        return Sources.fromJson(bodyAsJson).getValue();
    }

    public Dataset createDataset(@NonNull String namespaceName, @NonNull String datasetName, @NonNull DatasetMeta datasetMeta) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(datasetMeta, "datasetMeta is marked non-null but is null");
        String bodyAsJson = this.http.put(this.url.toDatasetUrl(namespaceName, datasetName), datasetMeta.toJson());
        return Dataset.fromJson(bodyAsJson);
    }

    public Dataset getDataset(@NonNull String namespaceName, @NonNull String datasetName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toDatasetUrl(namespaceName, datasetName));
        return Dataset.fromJson(bodyAsJson);
    }

    public Dataset deleteDataset(@NonNull String namespaceName, @NonNull String datasetName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        String bodyAsJson = this.http.delete(this.url.toDatasetUrl(namespaceName, datasetName));
        return Dataset.fromJson(bodyAsJson);
    }

    public void deleteNamespace(@NonNull String namespaceName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        this.http.delete(this.url.toNamespaceUrl(namespaceName));
    }

    public DatasetVersion getDatasetVersion(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String version) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(version, "version is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toDatasetVersionUrl(namespaceName, datasetName, version));
        return DatasetVersion.fromJson(bodyAsJson);
    }

    public List<DatasetVersion> listDatasetVersions(@NonNull String namespaceName, @NonNull String datasetName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        return this.listDatasetVersions(namespaceName, datasetName, 100, 0);
    }

    public List<DatasetVersion> listDatasetVersions(@NonNull String namespaceName, @NonNull String datasetName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toListDatasetVersionsUrl(namespaceName, datasetName, limit, offset));
        return DatasetVersions.fromJson(bodyAsJson).getValue();
    }

    public List<Dataset> listDatasets(String namespaceName) {
        return this.listDatasets(namespaceName, 100, 0);
    }

    public List<Dataset> listDatasets(@NonNull String namespaceName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toListDatasetsUrl(namespaceName, limit, offset));
        return Datasets.fromJson(bodyAsJson).getValue();
    }

    public Dataset tagDatasetWith(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String tagName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(tagName, "tagName is marked non-null but is null");
        String bodyAsJson = this.http.post(this.url.toDatasetTagUrl(namespaceName, datasetName, tagName));
        return Dataset.fromJson(bodyAsJson);
    }

    public Dataset tagFieldWith(@NonNull String namespaceName, @NonNull String datasetName, @NonNull String fieldName, @NonNull String tagName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(datasetName, "datasetName is marked non-null but is null");
        Objects.requireNonNull(fieldName, "fieldName is marked non-null but is null");
        Objects.requireNonNull(tagName, "tagName is marked non-null but is null");
        String bodyAsJson = this.http.post(this.url.toFieldTagURL(namespaceName, datasetName, fieldName, tagName));
        return Dataset.fromJson(bodyAsJson);
    }

    public Job createJob(@NonNull String namespaceName, @NonNull String jobName, @NonNull JobMeta jobMeta) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        Objects.requireNonNull(jobMeta, "jobMeta is marked non-null but is null");
        String bodyAsJson = this.http.put(this.url.toJobUrl(namespaceName, jobName), jobMeta.toJson());
        return Job.fromJson(bodyAsJson);
    }

    public Job getJob(@NonNull String namespaceName, @NonNull String jobName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toJobUrl(namespaceName, jobName));
        return Job.fromJson(bodyAsJson);
    }

    public Job deleteJob(@NonNull String namespaceName, @NonNull String jobName) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        String bodyAsJson = this.http.delete(this.url.toJobUrl(namespaceName, jobName));
        return Job.fromJson(bodyAsJson);
    }

    public JobVersion getJobVersion(@NonNull String namespaceName, @NonNull String jobName, String version) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toJobVersionUrl(namespaceName, jobName, version));
        return JobVersion.fromJson(bodyAsJson);
    }

    public List<Job> listJobs(String namespaceName) {
        return this.listJobs(namespaceName, 100, 0);
    }

    public List<Job> listJobs(@NonNull String namespaceName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toListJobsUrl(namespaceName, limit, offset));
        return Jobs.fromJson(bodyAsJson).getValue();
    }

    public List<JobVersion> listJobVersions(@NonNull String namespaceName, String jobName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toListJobVersionsUrl(namespaceName, jobName, limit, offset));
        return JobVersions.fromJson(bodyAsJson).getValue();
    }

    public Run createRun(String namespaceName, String jobName, RunMeta runMeta) {
        return this.createRun(namespaceName, jobName, runMeta, false);
    }

    private Run createRun(@NonNull String namespaceName, @NonNull String jobName, @NonNull RunMeta runMeta, boolean markRunAsRunning) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        Objects.requireNonNull(runMeta, "runMeta is marked non-null but is null");
        String bodyAsJson = this.http.post(this.url.toCreateRunUrl(namespaceName, jobName), runMeta.toJson());
        Run run = Run.fromJson(bodyAsJson);
        return markRunAsRunning ? this.markRunAsRunning(run.getId()) : run;
    }

    public Run createRunAndStart(String namespaceName, String jobName, RunMeta runMeta) {
        return this.createRun(namespaceName, jobName, runMeta, true);
    }

    public Run getRun(@NonNull String runId) {
        Objects.requireNonNull(runId, "runId is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toRunUrl(runId));
        return Run.fromJson(bodyAsJson);
    }

    public List<Run> listRuns(String namespaceName, String jobName) {
        return this.listRuns(namespaceName, jobName, 100, 0);
    }

    public List<Run> listRuns(@NonNull String namespaceName, @NonNull String jobName, int limit, int offset) {
        Objects.requireNonNull(namespaceName, "namespaceName is marked non-null but is null");
        Objects.requireNonNull(jobName, "jobName is marked non-null but is null");
        String bodyAsJson = this.http.get(this.url.toListRunsUrl(namespaceName, jobName, limit, offset));
        return Runs.fromJson(bodyAsJson).getValue();
    }

    public Run markRunAs(String runId, RunState runState) {
        return this.markRunAs(runId, runState, null);
    }

    public Run markRunAs(String runId, @NonNull RunState runState, @Nullable Instant at) {
        Objects.requireNonNull(runState, "runState is marked non-null but is null");
        String bodyAsJson = this.http.post(this.url.toRunTransitionUrl(runId, runState, at));
        return Run.fromJson(bodyAsJson);
    }

    public Run markRunAsRunning(String runId) {
        return this.markRunAsRunning(runId, null);
    }

    public Run markRunAsRunning(String runId, @Nullable Instant at) {
        return this.markRunAs(runId, RunState.RUNNING, at);
    }

    public Run markRunAsCompleted(String runId) {
        return this.markRunAsCompleted(runId, null);
    }

    public Run markRunAsCompleted(String runId, @Nullable Instant at) {
        return this.markRunAs(runId, RunState.COMPLETED, at);
    }

    public Run markRunAsAborted(String runId) {
        return this.markRunAsAborted(runId, null);
    }

    public Run markRunAsAborted(String runId, @Nullable Instant at) {
        return this.markRunAs(runId, RunState.ABORTED, at);
    }

    public Run markRunAsFailed(String runId) {
        return this.markRunAsFailed(runId, null);
    }

    public Run markRunAsFailed(String runId, @Nullable Instant at) {
        return this.markRunAs(runId, RunState.FAILED, at);
    }

    public Set<Tag> listTags() {
        return this.listTags(100, 0);
    }

    public Set<Tag> listTags(int limit, int offset) {
        String bodyAsJson = this.http.get(this.url.toListTagsUrl(limit, offset));
        return Tags.fromJson(bodyAsJson).getValue();
    }

    public Tag createTag(String name, String description) {
        String tagAsJson = this.http.put(this.url.toCreateTagsUrl(name), new TagDescription(description).toJson());
        return Tag.fromJson(tagAsJson);
    }

    public Tag createTag(String tag) {
        return this.createTag(tag, null);
    }

    public SearchResults search(String query) {
        return this.search(query, null, null, 100);
    }

    public SearchResults search(@NonNull String query, @NonNull SearchFilter filter) {
        Objects.requireNonNull(query, "query is marked non-null but is null");
        Objects.requireNonNull(filter, "filter is marked non-null but is null");
        return this.search(query, filter, null, 100);
    }

    public SearchResults search(@NonNull String query, @NonNull SearchSort sort) {
        Objects.requireNonNull(query, "query is marked non-null but is null");
        Objects.requireNonNull(sort, "sort is marked non-null but is null");
        return this.search(query, null, sort, 100);
    }

    public SearchResults search(@NonNull String query, int limit) {
        Objects.requireNonNull(query, "query is marked non-null but is null");
        return this.search(query, null, null, limit);
    }

    public SearchResults search(String query, @Nullable SearchFilter filter, @Nullable SearchSort sort, int limit) {
        String bodyAsJson = this.http.get(this.url.toSearchUrl(query, filter, sort, limit));
        return SearchResults.fromJson(bodyAsJson);
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Version {
        private static final String CONFIG_PROPERTIES = "config.properties";
        private static final String VERSION_PROPERTY_NAME = "version";
        private static final String VERSION_UNKNOWN = "unknown";
        private final String value;
        public static Version NO_VERSION = new Version("unknown");

        private Version(@NonNull String value) {
            Objects.requireNonNull(value, "value is marked non-null but is null");
            this.value = value;
        }

        static Version get() {
            Version version;
            block8: {
                Properties properties = new Properties();
                InputStream stream = MarquezClient.class.getClassLoader().getResourceAsStream(CONFIG_PROPERTIES);
                try {
                    properties.load(stream);
                    version = new Version(properties.getProperty(VERSION_PROPERTY_NAME, VERSION_UNKNOWN));
                    if (stream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.warn("Failed to load properties file: {}", (Object)CONFIG_PROPERTIES, (Object)e);
                        return NO_VERSION;
                    }
                }
                stream.close();
            }
            return version;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Version)) {
                return false;
            }
            Version other = (Version)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Version(value=" + this.getValue() + ")";
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum SortDirection {
        DESC("desc"),
        ASC("asc");

        public final String value;

        @Generated
        private SortDirection(String value) {
            this.value = value;
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static final class Events
    extends ResultsPage {
        private final List<LineageEvent> value;

        @JsonCreator
        Events(@JsonProperty(value="events") List<LineageEvent> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Events fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Events>(){});
        }

        @Generated
        public String toString() {
            return "MarquezClient.Events(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Events)) {
                return false;
            }
            Events other = (Events)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<LineageEvent> this$value = this.getValue();
            List<LineageEvent> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Events;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<LineageEvent> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public List<LineageEvent> getValue() {
            return this.value;
        }
    }

    public static final class Lineage {
        private final Set<Node> graph;

        @JsonCreator
        Lineage(@JsonProperty(value="graph") Set<Node> value) {
            this.graph = ImmutableSet.copyOf(value);
        }

        static Lineage fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Lineage>(){});
        }

        String toJson() {
            return Utils.toJson(this);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Lineage)) {
                return false;
            }
            Lineage other = (Lineage)o;
            Set<Node> this$graph = this.getGraph();
            Set<Node> other$graph = other.getGraph();
            return !(this$graph == null ? other$graph != null : !((Object)this$graph).equals(other$graph));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Node> $graph = this.getGraph();
            result = result * 59 + ($graph == null ? 43 : ((Object)$graph).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Lineage(graph=" + this.getGraph() + ")";
        }

        @Generated
        public Set<Node> getGraph() {
            return this.graph;
        }
    }

    static final class Namespaces {
        private final List<Namespace> value;

        @JsonCreator
        Namespaces(@JsonProperty(value="namespaces") List<Namespace> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Namespaces fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Namespaces>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Namespaces)) {
                return false;
            }
            Namespaces other = (Namespaces)o;
            List<Namespace> this$value = this.getValue();
            List<Namespace> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Namespace> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Namespaces(value=" + this.getValue() + ")";
        }

        @Generated
        public List<Namespace> getValue() {
            return this.value;
        }
    }

    static final class Sources {
        private final List<Source> value;

        @JsonCreator
        Sources(@JsonProperty(value="sources") List<Source> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Sources fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Sources>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sources)) {
                return false;
            }
            Sources other = (Sources)o;
            List<Source> this$value = this.getValue();
            List<Source> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Source> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Sources(value=" + this.getValue() + ")";
        }

        @Generated
        public List<Source> getValue() {
            return this.value;
        }
    }

    static final class DatasetVersions {
        private final List<DatasetVersion> value;

        @JsonCreator
        DatasetVersions(@JsonProperty(value="versions") List<DatasetVersion> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static DatasetVersions fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<DatasetVersions>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatasetVersions)) {
                return false;
            }
            DatasetVersions other = (DatasetVersions)o;
            List<DatasetVersion> this$value = this.getValue();
            List<DatasetVersion> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DatasetVersion> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.DatasetVersions(value=" + this.getValue() + ")";
        }

        @Generated
        public List<DatasetVersion> getValue() {
            return this.value;
        }
    }

    public static final class Datasets
    extends ResultsPage {
        private final List<Dataset> value;

        @JsonCreator
        Datasets(@JsonProperty(value="datasets") List<Dataset> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Datasets fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Datasets>(){});
        }

        @Generated
        public String toString() {
            return "MarquezClient.Datasets(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Datasets)) {
                return false;
            }
            Datasets other = (Datasets)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Dataset> this$value = this.getValue();
            List<Dataset> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Datasets;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Dataset> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public List<Dataset> getValue() {
            return this.value;
        }
    }

    static final class Jobs
    extends ResultsPage {
        private final List<Job> value;

        @JsonCreator
        Jobs(@JsonProperty(value="jobs") List<Job> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Jobs fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Jobs>(){});
        }

        @Generated
        public String toString() {
            return "MarquezClient.Jobs(value=" + this.getValue() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jobs)) {
                return false;
            }
            Jobs other = (Jobs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Job> this$value = this.getValue();
            List<Job> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Jobs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Job> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public List<Job> getValue() {
            return this.value;
        }
    }

    static final class JobVersions {
        private final List<JobVersion> value;

        @JsonCreator
        JobVersions(@JsonProperty(value="versions") List<JobVersion> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static JobVersions fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<JobVersions>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JobVersions)) {
                return false;
            }
            JobVersions other = (JobVersions)o;
            List<JobVersion> this$value = this.getValue();
            List<JobVersion> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JobVersion> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.JobVersions(value=" + this.getValue() + ")";
        }

        @Generated
        public List<JobVersion> getValue() {
            return this.value;
        }
    }

    static final class Runs {
        private final List<Run> value;

        @JsonCreator
        Runs(@JsonProperty(value="runs") List<Run> value) {
            this.value = ImmutableList.copyOf(value);
        }

        static Runs fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Runs>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Runs)) {
                return false;
            }
            Runs other = (Runs)o;
            List<Run> this$value = this.getValue();
            List<Run> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Run> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Runs(value=" + this.getValue() + ")";
        }

        @Generated
        public List<Run> getValue() {
            return this.value;
        }
    }

    static final class Tags {
        private final Set<Tag> value;

        @JsonCreator
        Tags(@JsonProperty(value="tags") Set<Tag> value) {
            this.value = ImmutableSet.copyOf(value);
        }

        static Tags fromJson(String json) {
            return Utils.fromJson(json, new TypeReference<Tags>(){});
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tags)) {
                return false;
            }
            Tags other = (Tags)o;
            Set<Tag> this$value = this.getValue();
            Set<Tag> other$value = other.getValue();
            return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Tag> $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.Tags(value=" + this.getValue() + ")";
        }

        @Generated
        public Set<Tag> getValue() {
            return this.value;
        }
    }

    static final class TagDescription {
        @JsonProperty(value="description")
        private final String value;

        String toJson() {
            return Utils.toJson(this);
        }

        @Generated
        public TagDescription(String value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TagDescription)) {
                return false;
            }
            TagDescription other = (TagDescription)o;
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MarquezClient.TagDescription(value=" + this.getValue() + ")";
        }

        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static final class Builder {
        @VisibleForTesting
        URL baseUrl = DEFAULT_BASE_URL;
        @Nullable
        @VisibleForTesting
        String apiKey;
        @Nullable
        @VisibleForTesting
        SSLContext sslContext;

        private Builder() {
        }

        public Builder baseUrl(@NonNull String baseUrlString) {
            Objects.requireNonNull(baseUrlString, "baseUrlString is marked non-null but is null");
            return this.baseUrl(Utils.toUrl(baseUrlString));
        }

        public Builder baseUrl(@NonNull URL baseUrl) {
            Objects.requireNonNull(baseUrl, "baseUrl is marked non-null but is null");
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder apiKey(@Nullable String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder sslContext(@Nullable SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public MarquezClient build() {
            return new MarquezClient(MarquezUrl.create(this.baseUrl), MarquezHttp.create(this.sslContext, Version.get(), this.apiKey));
        }
    }

    static class ResultsPage {
        @JsonProperty
        int totalCount;

        @Generated
        public ResultsPage() {
        }

        @JsonProperty
        @Generated
        public void setTotalCount(int totalCount) {
            this.totalCount = totalCount;
        }

        @Generated
        public int getTotalCount() {
            return this.totalCount;
        }
    }
}

